/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.registries;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LHECoolantRegistry {
    private static final Map<String, LHECoolantInfo> lheCoolants = new HashMap<String, LHECoolantInfo>();

    public static void registerCoolant(String coldFluidName, String hotFluidName, double steamMultiplier, double superheatedThreshold) {
        LHECoolantInfo coolant = new LHECoolantInfo(coldFluidName, hotFluidName, steamMultiplier, superheatedThreshold);
        lheCoolants.put(hotFluidName, coolant);
    }

    public static LHECoolantInfo getCoolant(String fluidName) {
        return lheCoolants.get(fluidName);
    }

    public static LHECoolantInfo getCoolant(Fluid fluid) {
        return lheCoolants.get(fluid.getName());
    }

    public static void registerBaseCoolants() {
        LHECoolantRegistry.registerCoolant("ic2pahoehoelava", "lava", 0.2, 0.25);
        LHECoolantRegistry.registerCoolant("ic2coolant", "ic2hotcoolant", 0.5, 0.2);
        LHECoolantRegistry.registerCoolant("molten.solarsaltcold", "molten.solarsalthot", 2.5, 0.04);
    }

    public static class LHECoolantInfo {
        public final String coldFluidName;
        public final String hotFluidName;
        public final double steamMultiplier;
        public final double superheatedThreshold;
        private Fluid coldFluid;
        private Fluid hotFluid;

        public LHECoolantInfo(String coldFluidName, String hotFluidName, double steamMultiplier, double superheatedThreshold) {
            this.coldFluidName = coldFluidName;
            this.hotFluidName = hotFluidName;
            this.steamMultiplier = steamMultiplier;
            this.superheatedThreshold = superheatedThreshold;
        }

        public Fluid getColdFluid() {
            if (this.coldFluid == null) {
                this.coldFluid = FluidRegistry.getFluid((String)this.coldFluidName);
            }
            return this.coldFluid;
        }

        public Fluid getHotFluid() {
            if (this.hotFluid == null) {
                this.hotFluid = FluidRegistry.getFluid((String)this.hotFluidName);
            }
            return this.hotFluid;
        }

        public FluidStack getColdFluid(int amount) {
            return new FluidStack(this.getColdFluid(), amount);
        }

        public FluidStack getHotFluid(int amount) {
            return new FluidStack(this.getHotFluid(), amount);
        }
    }
}

