/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class FindRecipeQuery {
    private static final Predicate<GTRecipe> ALWAYS = r -> true;
    private final RecipeMap<?> recipeMap;
    @Nullable
    private ItemStack[] items;
    @Nullable
    private FluidStack[] fluids;
    @Nullable
    private ItemStack specialSlot;
    private Predicate<GTRecipe> filter = ALWAYS;
    private long voltage = Integer.MAX_VALUE;
    @Nullable
    private GTRecipe cachedRecipe;
    private boolean notUnificated;
    private boolean dontCheckStackSizes;
    private boolean forCollisionCheck;
    private boolean caching = false;

    FindRecipeQuery(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    @Nullable
    public GTRecipe find() {
        return this.findAll().findFirst().orElse(null);
    }

    public Stream<GTRecipe> findAll() {
        if (this.items == null) {
            this.items = GTValues.emptyItemStackArray;
        }
        if (this.fluids == null) {
            this.fluids = GTValues.emptyFluidStackArray;
        }
        return ((RecipeMapBackend)this.recipeMap.getBackend()).matchRecipeStream(this.items, this.fluids, this.specialSlot, this.cachedRecipe, this.notUnificated, this.dontCheckStackSizes, this.forCollisionCheck).filter((? super T recipe) -> this.voltage * (long)this.recipeMap.getAmperage() >= (long)recipe.mEUt && this.filter.test((GTRecipe)recipe)).peek(recipe -> {
            if (this.caching) {
                ((RecipeMapBackend)this.recipeMap.getBackend()).cache(this.items, this.fluids, (GTRecipe)recipe);
            }
        });
    }

    public boolean checkCollision() {
        this.dontCheckStackSizes = true;
        this.forCollisionCheck = true;
        return this.findAll().findAny().isPresent();
    }

    public FindRecipeQuery items(ItemStack ... items) {
        this.items = items;
        return this;
    }

    public FindRecipeQuery fluids(FluidStack ... fluids) {
        this.fluids = fluids;
        return this;
    }

    public FindRecipeQuery specialSlot(@Nullable ItemStack specialSlot) {
        this.specialSlot = specialSlot;
        return this;
    }

    public FindRecipeQuery filter(Predicate<GTRecipe> filter) {
        this.filter = filter;
        return this;
    }

    public FindRecipeQuery voltage(long voltage) {
        this.voltage = voltage;
        return this;
    }

    public FindRecipeQuery cachedRecipe(@Nullable GTRecipe cachedRecipe) {
        this.cachedRecipe = cachedRecipe;
        return this;
    }

    public FindRecipeQuery notUnificated(boolean notUnificated) {
        this.notUnificated = notUnificated;
        return this;
    }

    public FindRecipeQuery dontCheckStackSizes(boolean dontCheckStackSizes) {
        this.dontCheckStackSizes = dontCheckStackSizes;
        return this;
    }

    public FindRecipeQuery caching(boolean caching) {
        this.caching = caching;
        return this;
    }
}

