/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net.cape;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.net.cape.GTPacketBroadcastCapes;
import gregtech.common.GTCapesLoader;
import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

@ParametersAreNonnullByDefault
public class GTPacketSetCape
extends GTPacket {
    private String cape;
    private EntityPlayerMP player;

    public GTPacketSetCape() {
    }

    public GTPacketSetCape(String cape) {
        this.cape = cape;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.SET_CAPE.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.cape);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        return new GTPacketSetCape(GTPacketSetCape.readUTF8String(buffer));
    }

    @Override
    public void process(IBlockAccess world) {
        if (!GTCapesLoader.getAvailableCapes((EntityPlayer)this.player).contains(this.cape)) {
            this.player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not own \"" + this.cape + "\"!"));
            return;
        }
        GTCapesLoader.setSelectedCape((EntityPlayer)this.player, this.cape);
        GTValues.NW.sendToAll(new GTPacketBroadcastCapes(this.player.func_110124_au(), this.cape));
    }

    @Override
    public void setINetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer handlerPlayServer = (NetHandlerPlayServer)handler;
            this.player = handlerPlayServer.field_147369_b;
        }
    }
}

