/*
 * Decompiled with CFR 0.152.
 */
package ggfab.mte;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import ggfab.GGConstants;
import gregtech.api.enums.ItemList;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.util.ForgeDirection;

public class MTELinkedInputBus
extends MTEHatchInputBus
implements IRecipeProcessingAwareHatch,
IDataCopyable {
    public static final int SIZE_INVENTORY = 18;
    public static final String COPIED_DATA_IDENTIFIER = "linkedinputbus";
    private SharedInventory mRealInventory;
    private final ItemStackHandlerProxy handler = new ItemStackHandlerProxy();
    private String mChannel;
    private boolean mPrivate;
    private State mState;
    private WorldSave save;

    public MTELinkedInputBus(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier, 1, new String[]{"18 slot input bus linked together wirelessly", "Link does not cross world boundary", "Left/right click with data stick to copy/paste configuration", GGConstants.GGMARK_TOOLTIP});
    }

    public MTELinkedInputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELinkedInputBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int getCircuitSlot() {
        return 0;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextFieldWidget().setSynced(true, true).setGetter(() -> this.mChannel == null ? "" : this.mChannel).setSetter(this::setChannel).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setGTTooltip(() -> this.mTooltipCache.getData("ggfab.tooltip.linked_input_bus.change_freq_warn", new Object[0])).setSize(60, 18).setPos(48, 3))).widget(new CycleButtonWidget().setToggle(this::isPrivate, this::setPrivate).setTextureGetter(i -> i == 1 ? GTUITextures.OVERLAY_BUTTON_CHECKMARK : GTUITextures.OVERLAY_BUTTON_CROSS).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setSynced(true, true).setGTTooltip(() -> this.mTooltipCache.getData("ggfab.tooltip.linked_input_bus.private", new Object[0])).setSize(18, 18).setPos(150, 3))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.handler, (int)9).startFromSlot(0).endAtSlot(17).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).slotCreator(i -> new BaseSlot((IItemHandlerModifiable)this.handler, (int)i, false){

            public ItemStack func_75211_c() {
                return this.isEnabled() ? super.func_75211_c() : null;
            }

            public boolean isEnabled() {
                return MTELinkedInputBus.this.mChannel != null;
            }
        }).build().setPos(7, 24))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"ggfab.gui.linked_input_bus.private"))).setPos(110, 3).setSize(43, 20))).widget(new TextWidget(new Text(StatCollector.func_74838_a((String)"ggfab.gui.linked_input_bus.channel"))).setPos(5, 3).setSize(43, 20));
    }

    @Override
    public int getCircuitSlotX() {
        return 152;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        if (aIndex == this.getCircuitSlot()) {
            return super.func_70301_a(aIndex);
        }
        if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null && aIndex > 0 && aIndex <= 18) {
            return this.mRealInventory.stacks[aIndex - 1];
        }
        return null;
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex == this.getCircuitSlot()) {
            this.mInventory[0] = GTUtility.copyAmount(0, aStack);
            this.func_70296_d();
        } else if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null && aIndex > 0 && aIndex <= 18) {
            ((SharedInventory)this.mRealInventory).stacks[aIndex - 1] = aStack;
            this.getWorldSave().func_76185_a();
        }
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return super.getTexturesActive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return super.getTexturesInactive(aBaseTexture);
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && this.mChannel != null && this.mRealInventory != null && aIndex > this.getCircuitSlot() && aIndex < 19 && (this.mRealInventory.stacks[aIndex - 1] == null || GTUtility.areStacksEqual(aStack, this.mRealInventory.stacks[aIndex - 1])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return !(side != this.getBaseMetaTileEntity().getFrontFacing() || aIndex == this.getCircuitSlot() || this.mRecipeMap != null && !this.disableFilter && !this.mRecipeMap.containsInput(aStack) || !this.mRealInventory.disableLimited && !this.limitedAllowPutStack(aIndex, aStack));
    }

    @Override
    protected boolean limitedAllowPutStack(int aIndex, ItemStack aStack) {
        for (int i = 0; i < 18; ++i) {
            if (!GTUtility.areStacksEqual(GTOreDictUnificator.get_nocopy(aStack), this.mRealInventory.stacks[i])) continue;
            return i == aIndex - 1;
        }
        return this.mRealInventory.stacks[aIndex - 1] == null;
    }

    @Override
    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null) {
            return 19;
        }
        return 1;
    }

    @Override
    public void startRecipeProcessing() {
        if (this.mRealInventory == null) {
            return;
        }
        if (this.mRealInventory.used) {
            this.mState = State.Blocked;
        } else {
            this.mRealInventory.used = true;
            this.mState = State.Activated;
        }
    }

    @Override
    public CheckRecipeResult endRecipeProcessing(MTEMultiBlockBase controller) {
        if (this.mState == State.Activated) {
            assert (this.mRealInventory != null);
            this.mRealInventory.used = false;
        }
        this.mState = State.Default;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public void updateSlots() {
        if (this.mChannel == null || this.mRealInventory == null) {
            return;
        }
        for (int i = 0; i < this.mRealInventory.stacks.length; ++i) {
            if (this.mRealInventory.stacks[i] == null || this.mRealInventory.stacks[i].func_77973_b() != null && ((SharedInventory)this.mRealInventory).stacks[i].field_77994_a > 0) continue;
            ((SharedInventory)this.mRealInventory).stacks[i] = null;
        }
        if (!this.mRealInventory.disableSort) {
            this.fillStacksIntoFirstSlots();
        }
        this.func_70296_d();
        this.getWorldSave().func_76185_a();
    }

    @Override
    protected void fillStacksIntoFirstSlots() {
        if (this.mRealInventory == null) {
            return;
        }
        int L = 18;
        HashMap<GTUtility.ItemId, Integer> slots = new HashMap<GTUtility.ItemId, Integer>(18);
        HashMap<GTUtility.ItemId, ItemStack> stacks = new HashMap<GTUtility.ItemId, ItemStack>(18);
        ArrayList<GTUtility.ItemId> order = new ArrayList<GTUtility.ItemId>(18);
        ArrayList<Integer> validSlots = new ArrayList<Integer>(18);
        for (int i = 0; i < 18; ++i) {
            validSlots.add(i);
            ItemStack s = this.mRealInventory.stacks[i];
            if (s == null) continue;
            GTUtility.ItemId sID = GTUtility.ItemId.createNoCopy(s);
            slots.merge(sID, s.field_77994_a, Integer::sum);
            if (!stacks.containsKey(sID)) {
                stacks.put(sID, s);
            }
            order.add(sID);
            ((SharedInventory)this.mRealInventory).stacks[i] = null;
        }
        int slotindex = 0;
        for (GTUtility.ItemId sID : order) {
            int toSet = (Integer)slots.get(sID);
            if (toSet == 0) continue;
            int slot = (Integer)validSlots.get(slotindex);
            ++slotindex;
            ((SharedInventory)this.mRealInventory).stacks[slot] = ((ItemStack)stacks.get(sID)).func_77946_l();
            ((SharedInventory)this.mRealInventory).stacks[slot].field_77994_a = toSet = Math.min(toSet, this.mRealInventory.stacks[slot].func_77976_d());
            slots.merge(sID, toSet, (a, b) -> a - b);
        }
    }

    private void dropItems(ItemStack[] aStacks) {
        for (ItemStack stack : aStacks) {
            if (!GTUtility.isStackValid(stack)) continue;
            EntityItem ei = new EntityItem(this.getBaseMetaTileEntity().getWorld(), (double)this.getBaseMetaTileEntity().getOffsetX(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetY(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetZ(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, stack);
            ei.field_70179_y = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70159_w = 0.0;
            this.getBaseMetaTileEntity().getWorld().func_72838_d((Entity)ei);
        }
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return this.mRealInventory != null && this.mRealInventory.ref <= 0;
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (this.mRealInventory != null && --this.mRealInventory.ref <= 0) {
            this.getWorldSave().remove(this.mChannel);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mChannel != null) {
            aNBT.func_74778_a("channel", this.mChannel);
        }
        aNBT.func_74757_a("private", this.mPrivate);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        String channel = aNBT.func_74779_i("channel");
        if ("".equals(channel)) {
            channel = null;
        }
        this.mChannel = channel;
        this.mPrivate = aNBT.func_74767_n("private");
    }

    public String getChannel() {
        return this.mChannel;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (this.mChannel != null) {
            this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
            this.handler.set(this.mRealInventory.stacks);
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).isGUIClickable()) {
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (this.mRealInventory == null) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_channel", new Object[0]));
                return;
            }
            if (this.mRealInventory.disableSort) {
                this.mRealInventory.disableSort = false;
            } else if (this.mRealInventory.disableLimited) {
                this.mRealInventory.disableLimited = false;
            } else {
                this.mRealInventory.disableSort = true;
                this.mRealInventory.disableLimited = true;
            }
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableSort." + this.mRealInventory.disableSort)) + "   " + StatCollector.func_74838_a((String)("GT5U.hatch.disableLimited." + this.mRealInventory.disableLimited)));
        } else {
            this.disableFilter = !this.disableFilter;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.disableFilter)));
        }
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        if (this.getChannel() == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", COPIED_DATA_IDENTIFIER);
        tag.func_74778_a("channel", this.getChannel());
        tag.func_74782_a("circuit", (NBTBase)GTUtility.saveItem(this.func_70301_a(this.getCircuitSlot())));
        if (this.isPrivate()) {
            tag.func_74772_a("owner1", this.getBaseMetaTileEntity().getOwnerUuid().getMostSignificantBits());
            tag.func_74772_a("owner2", this.getBaseMetaTileEntity().getOwnerUuid().getLeastSignificantBits());
        }
        return tag;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        UUID owner;
        if (nbt == null || !COPIED_DATA_IDENTIFIER.equals(nbt.func_74779_i("ggfab.type")) && !COPIED_DATA_IDENTIFIER.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        ItemStack circuit = GTUtility.loadItem(nbt, "circuit");
        String channel = nbt.func_74779_i("channel");
        if (GTUtility.isStackInvalid(circuit)) {
            circuit = null;
        }
        if ("".equals(channel)) {
            return false;
        }
        if (circuit != null) {
            if (GTUtility.getAllIntegratedCircuits().stream().noneMatch(arg_0 -> ((ItemStack)circuit).func_77969_a(arg_0))) {
                return false;
            }
        }
        UUID uUID = owner = nbt.func_74764_b("owner1") ? new UUID(nbt.func_74763_f("owner1"), nbt.func_74763_f("owner2")) : null;
        if (owner != null && !owner.equals(this.getBaseMetaTileEntity().getOwnerUuid())) {
            return false;
        }
        this.setPrivate(owner != null);
        this.setChannel(channel);
        this.func_70299_a(this.getCircuitSlot(), circuit);
        return true;
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return COPIED_DATA_IDENTIFIER;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        UUID owner;
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        ItemStack stick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(stick, false, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        if (!stick.func_77942_o() || !COPIED_DATA_IDENTIFIER.equals(stick.field_77990_d.func_74779_i("ggfab.type")) && !COPIED_DATA_IDENTIFIER.equals(stick.field_77990_d.func_74779_i("type"))) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_data", new Object[0]));
            return true;
        }
        ItemStack circuit = GTUtility.loadItem(stick.field_77990_d, "circuit");
        String channel = stick.field_77990_d.func_74779_i("channel");
        if (GTUtility.isStackInvalid(circuit)) {
            circuit = null;
        }
        if ("".equals(channel)) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_data", new Object[0]));
            return true;
        }
        if (circuit != null) {
            if (GTUtility.getAllIntegratedCircuits().stream().noneMatch(arg_0 -> ((ItemStack)circuit).func_77969_a(arg_0))) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.invalid_circuit", new Object[0]));
                return true;
            }
        }
        UUID uUID = owner = stick.field_77990_d.func_74764_b("owner1") ? new UUID(stick.field_77990_d.func_74763_f("owner1"), stick.field_77990_d.func_74763_f("owner2")) : null;
        if (owner != null && !owner.equals(this.getBaseMetaTileEntity().getOwnerUuid())) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.not_owned", new Object[0]));
            return true;
        }
        this.setPrivate(owner != null);
        this.setChannel(channel);
        this.func_70299_a(this.getCircuitSlot(), circuit);
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.data_pasted", new Object[]{channel}));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack stick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(stick, false, true)) {
            return;
        }
        if (this.getChannel() == null) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_channel", new Object[0]));
            return;
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.data_copied", new Object[]{this.getChannel()}));
        stick.field_77990_d = this.getCopiedData(aPlayer);
        stick.func_151001_c("Linked Input Bus configuration");
        GTUtility.ItemNBT.setBookTitle(stick, "Channel: " + this.getChannel());
        if (this.getBaseMetaTileEntity().getOwnerName() != null) {
            GTUtility.ItemNBT.setBookAuthor(stick, this.getBaseMetaTileEntity().getOwnerName());
        }
    }

    private String getRealChannel() {
        if (this.mChannel == null) {
            return null;
        }
        if (this.mPrivate) {
            return this.getBaseMetaTileEntity().getOwnerUuid() + this.mChannel;
        }
        return new UUID(0L, 0L) + this.mChannel;
    }

    public boolean isPrivate() {
        return this.mPrivate;
    }

    public void setPrivate(boolean aPrivate) {
        if (aPrivate == this.mPrivate) {
            return;
        }
        if (this.getBaseMetaTileEntity().isClientSide()) {
            this.mPrivate = aPrivate;
            return;
        }
        if (this.mChannel == null) {
            this.mPrivate = aPrivate;
            return;
        }
        this.getWorldSave().func_76185_a();
        if (--this.mRealInventory.ref <= 0) {
            this.dropItems(this.mRealInventory.stacks);
            this.getWorldSave().remove(this.getRealChannel());
        }
        this.mPrivate = aPrivate;
        this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
        this.handler.set(this.mRealInventory.stacks);
        this.mRealInventory.ref++;
        this.getWorldSave().func_76185_a();
    }

    public void setChannel(String aChannel) {
        if ("".equals(aChannel)) {
            aChannel = null;
        }
        if (this.getBaseMetaTileEntity().isClientSide()) {
            this.mChannel = aChannel;
            return;
        }
        if (Objects.equals(this.mChannel, aChannel)) {
            return;
        }
        if (this.mChannel != null && --this.mRealInventory.ref <= 0) {
            this.dropItems(this.mRealInventory.stacks);
            this.getWorldSave().remove(this.getRealChannel());
        }
        if (aChannel == null) {
            this.mChannel = null;
            this.mRealInventory = null;
            this.handler.setFake();
        } else {
            this.mChannel = aChannel;
            this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
            this.handler.set(this.mRealInventory.stacks);
            this.mRealInventory.ref++;
        }
        this.getWorldSave().func_76185_a();
    }

    private WorldSave getWorldSave() {
        if (this.save == null) {
            WorldSave save = (WorldSave)this.getBaseMetaTileEntity().getWorld().func_72943_a(WorldSave.class, "LinkedInputBusses");
            if (save == null) {
                save = new WorldSave("LinkedInputBusses");
                this.getBaseMetaTileEntity().getWorld().func_72823_a(save.field_76190_i, (WorldSavedData)save);
            }
            this.save = save;
        }
        return this.save;
    }

    private static class ItemStackHandlerProxy
    extends ItemStackHandler {
        private static final ItemStack[] EMPTY = new ItemStack[18];
        private boolean fake = true;

        public ItemStackHandlerProxy() {
            super(EMPTY);
        }

        public void setFake() {
            this.set(EMPTY);
            this.fake = true;
        }

        public boolean isFake() {
            return this.fake;
        }

        public void set(ItemStack[] stacks) {
            this.stacks = Arrays.asList(stacks);
            this.fake = false;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74757_a("fake", this.fake);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            this.fake = nbt.func_74767_n("fake");
        }
    }

    private static enum State {
        Activated,
        Blocked,
        Default;

    }

    private static class SharedInventory {
        private final ItemStack[] stacks = new ItemStack[18];
        private final ItemStackHandler inventoryHandler = new ItemStackHandler(this.stacks);
        public boolean disableLimited = true;
        public boolean disableSort;
        private boolean used;
        private int ref;

        public SharedInventory() {
        }

        public SharedInventory(NBTTagCompound tag) {
            for (int i = 0; i < 18; ++i) {
                String key = "" + i;
                if (!tag.func_150297_b(key, 10)) continue;
                this.stacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(key));
            }
            this.ref = tag.func_74762_e("ref");
            this.disableLimited = tag.func_74767_n("dl");
            this.disableSort = tag.func_74767_n("ds");
        }

        public NBTTagCompound save() {
            NBTTagCompound tag = new NBTTagCompound();
            for (int i = 0; i < 18; ++i) {
                ItemStack stack = this.stacks[i];
                if (stack == null) continue;
                tag.func_74782_a("" + i, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74768_a("ref", this.ref);
            tag.func_74757_a("ds", this.disableSort);
            tag.func_74757_a("dl", this.disableLimited);
            return tag;
        }
    }

    public static class WorldSave
    extends WorldSavedData {
        private final Map<String, SharedInventory> data = new HashMap<String, SharedInventory>();

        public WorldSave(String p_i2141_1_) {
            super(p_i2141_1_);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.data.clear();
            Set set = tag.field_74784_a.entrySet();
            for (Map.Entry e : set) {
                this.data.put((String)e.getKey(), new SharedInventory((NBTTagCompound)e.getValue()));
            }
        }

        public void func_76187_b(NBTTagCompound tag) {
            for (Map.Entry<String, SharedInventory> e : this.data.entrySet()) {
                if (e.getValue().ref <= 0) continue;
                tag.func_74782_a(e.getKey(), (NBTBase)e.getValue().save());
            }
        }

        public SharedInventory get(Object channel) {
            return this.data.computeIfAbsent(channel.toString(), k -> new SharedInventory());
        }

        public void remove(Object channel) {
            this.data.remove(channel.toString());
            this.func_76185_a();
        }
    }
}

