/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.SideReference;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.configs.Configuration;
import bartworks.common.items.ItemLabParts;
import bartworks.common.loaders.FluidLoader;
import bartworks.common.net.PacketBioVatRenderer;
import bartworks.common.tileentities.tiered.MTERadioHatch;
import bartworks.util.BWUtil;
import bartworks.util.BioCulture;
import bartworks.util.Coords;
import bartworks.util.MathUtils;
import bartworks.util.ResultWrongSievert;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.recipe.Sievert;
import gregtech.common.misc.GTStructureChannels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEBioVat
extends MTEEnhancedMultiBlockBase<MTEBioVat>
implements ISurvivalConstructable {
    public static final HashMap<Coords, Integer> staticColorMap = new HashMap();
    private static final byte TIMERDIVIDER = 20;
    private final HashSet<EntityPlayerMP> playerMPHashSet = new HashSet();
    private final ArrayList<MTERadioHatch> mRadHatches = new ArrayList();
    private int height = 1;
    private Fluid mFluid = FluidRegistry.LAVA;
    private BioCulture mCulture;
    private ItemStack mStack;
    private boolean needsVisualUpdate = true;
    private int glassTier = -1;
    private int mSievert;
    private int mNeededSievert;
    private int mCasing = 0;
    private int mExpectedMultiplier = 0;
    private int mTimes = 0;
    private boolean isVisibleFluid = false;
    private final Sievert defaultSievertData = new Sievert(0, false);
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEBioVat> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"cc~cc", "ccccc", "ccccc", "ccccc", "ccccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEBioVat.class).atLeast(HatchElement.Maintenance, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Energy, RadioHatchElement.RadioHatch).dot(1).casingIndex(49).build(), StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).addElement('a', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)FluidLoader.bioFluidBlock)})).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).build();

    public MTEBioVat(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEBioVat(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEBioVat> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Bacterial Vat, Bac Vat").addInfo("For maximum efficiency boost keep the Output Hatch always half filled!").beginStructureBlock(5, 4, 5, false).addController("Front bottom center").addCasingInfoMin("Clean Stainless Steel Casings", 19, false).addOtherStructurePart(StatCollector.func_74838_a((String)"tooltip.bw.structure.glass"), "Hollow two middle layers", 2).addCasingInfoExactly("Any Tiered Glass", 32, true).addStructureInfo("Some Recipes need more advanced Glass Types").addMaintenanceHatch("Any casing", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"tooltip.bw.structure.radio_hatch"), "Any casing", 1).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addInputHatch("Any casing", 1).addOutputHatch("Any casing", 1).addEnergyHatch("Any casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(new String[0]);
        return tt;
    }

    private int getInputCapacity() {
        return this.mInputHatches.stream().mapToInt(MTEHatchInput::getCapacity).sum();
    }

    private int getOutputCapacity() {
        return this.mOutputHatches.stream().mapToInt(MTEHatchOutput::getCapacity).sum();
    }

    @Override
    public int getCapacity() {
        int ret = 0;
        return ret += this.getInputCapacity();
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        return super.fill(resource, doFill);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.bacterialVatRecipes;
    }

    private int getExpectedMultiplier(@Nullable FluidStack recipeFluidOutput, boolean needEqual) {
        FluidStack storedFluidOutputs = this.getStoredFluidOutputs();
        if (storedFluidOutputs == null) {
            return 1;
        }
        if (!needEqual || storedFluidOutputs.isFluidEqual(recipeFluidOutput)) {
            return this.calcMod(storedFluidOutputs.amount) + 1;
        }
        return 1;
    }

    private int calcMod(double x) {
        double y = (double)this.getOutputCapacity() / 2.0;
        double z = Configuration.Multiblocks.bioVatMaxParallelBonus;
        int ret = MathUtils.ceilInt((-1.0 / y * (x - y) * (x - y) + y) / y * z);
        return MathUtils.clamp(1, ret, Configuration.Multiblocks.bioVatMaxParallelBonus);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                Sievert data = recipe.getMetadataOrDefault(GTRecipeConstants.SIEVERT, MTEBioVat.this.defaultSievertData);
                int sievert = data.sievert;
                boolean isExact = data.isExact;
                int glass = recipe.getMetadataOrDefault(GTRecipeConstants.GLASS, 0);
                if (!BWUtil.areStacksEqualOrNull((ItemStack)recipe.mSpecialItems, MTEBioVat.this.getControllerSlot())) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                MTEBioVat.this.mNeededSievert = sievert;
                if (MTEBioVat.this.glassTier < glass) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(glass);
                }
                if (!isExact) {
                    if (MTEBioVat.this.mSievert < MTEBioVat.this.mNeededSievert) {
                        return ResultWrongSievert.insufficientSievert(MTEBioVat.this.mNeededSievert);
                    }
                } else if (MTEBioVat.this.mSievert != sievert) {
                    return ResultWrongSievert.wrongSievert(sievert);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(MTEBioVat.this.recipeWithMultiplier(recipe, this.inputFluids));
            }
        };
    }

    protected GTRecipe recipeWithMultiplier(GTRecipe recipe, FluidStack[] fluidInputs) {
        int multiplier;
        GTRecipe tRecipe = recipe.copy();
        this.mExpectedMultiplier = multiplier = this.getExpectedMultiplier(recipe.getFluidOutput(0), true);
        long fluidAmount = 0L;
        for (FluidStack fluid : fluidInputs) {
            if (!recipe.mFluidInputs[0].isFluidEqual(fluid)) continue;
            fluidAmount += (long)fluid.amount;
        }
        multiplier = (int)Math.min((long)multiplier, fluidAmount / (long)recipe.mFluidInputs[0].amount);
        this.mTimes = multiplier = Math.max(multiplier, 1);
        tRecipe.mFluidInputs[0].amount *= multiplier;
        tRecipe.mFluidOutputs[0].amount *= multiplier;
        return tRecipe;
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpecialSlotItem(this.getControllerSlot());
    }

    public FluidStack getStoredFluidOutputs() {
        return ((MTEHatchOutput)this.mOutputHatches.get(0)).getFluid();
    }

    private boolean addRadiationInputToMachineList(IGregTechTileEntity aTileEntity, int CasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof MTERadioHatch)) {
            return false;
        }
        MTERadioHatch radioHatch = (MTERadioHatch)aMetaTileEntity;
        radioHatch.updateTexture(CasingIndex);
        return this.mRadHatches.add(radioHatch);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mRadHatches.clear();
        this.glassTier = -1;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        return this.mCasing >= 19 && this.mRadHatches.size() <= 1 && !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1 && this.mOutputHatches.size() == 1;
    }

    private void sendAllRequiredRendererPackets(int offsetX_L, int offsetY_L, int offsetZ_L, int offsetX_U, int offsetY_U, int offsetZ_U) {
        int height = this.reCalculateHeight();
        if (this.mFluid != null && height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = offsetX_L; x <= offsetX_U; ++x) {
                for (int y = offsetY_L; y <= offsetY_U; ++y) {
                    for (int z = offsetZ_L; z <= offsetZ_U; ++z) {
                        this.sendPackagesOrRenewRenderer(x, y, z, this.mCulture);
                    }
                }
            }
        }
    }

    private void sendPackagesOrRenewRenderer(int x, int y, int z, BioCulture lCulture) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        staticColorMap.remove(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g));
        staticColorMap.put(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB());
        if (SideReference.Side.Server) {
            GTValues.NW.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), new PacketBioVatRenderer(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
            GTValues.NW.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), new PacketBioVatRenderer(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), false), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
        }
        this.needsVisualUpdate = true;
    }

    private void check_Chunk(int offsetX_L, int offsetY_L, int offsetZ_L, int offsetX_U, int offsetY_U, int offsetZ_U) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        World aWorld = aBaseMetaTileEntity.getWorld();
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
                if (tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) {
                    if (this.playerMPHashSet.contains(tPlayer)) continue;
                    this.playerMPHashSet.add(tPlayer);
                    this.sendAllRequiredRendererPackets(offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
                    continue;
                }
                this.playerMPHashSet.remove(tPlayer);
            }
        }
    }

    private void placeFluid(int xDir, int zDir, int offsetX_L, int offsetY_L, int offsetZ_L, int offsetX_U, int offsetY_U, int offsetZ_U) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.isVisibleFluid = true;
        this.height = this.reCalculateHeight();
        if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = offsetX_L; x <= offsetX_U; ++x) {
                for (int y = offsetY_L; y <= offsetY_U; ++y) {
                    for (int z = offsetZ_L; z <= offsetZ_U; ++z) {
                        if (!aBaseMetaTileEntity.getWorld().func_147439_a(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord()).equals(Blocks.field_150350_a)) continue;
                        aBaseMetaTileEntity.getWorld().func_147449_b(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), FluidLoader.bioFluidBlock);
                    }
                }
            }
        }
    }

    private void removeFluid(int xDir, int zDir, int offsetX_L, int offsetY_L, int offsetZ_L, int offsetX_U, int offsetY_U, int offsetZ_U) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.isVisibleFluid = false;
        for (int x = offsetX_L; x <= offsetX_U; ++x) {
            for (int y = offsetY_L; y <= offsetY_U; ++y) {
                for (int z = offsetZ_L; z <= offsetZ_U; ++z) {
                    if (aBaseMetaTileEntity.getWorld().func_147439_a(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord()).equals(FluidLoader.bioFluidBlock)) {
                        aBaseMetaTileEntity.getWorld().func_147468_f(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord());
                    }
                    staticColorMap.remove(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord()), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g);
                }
            }
        }
    }

    private int reCalculateFluidAmmount() {
        return this.getStoredFluids().stream().mapToInt(fluidStack -> fluidStack.amount).sum();
    }

    private int reCalculateHeight() {
        return this.reCalculateFluidAmmount() > this.getCapacity() / 4 - 1 ? (this.reCalculateFluidAmmount() >= this.getCapacity() / 2 ? 3 : 2) : 1;
    }

    public void doAllVisualThings() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        ExtendedFacing f = this.getExtendedFacing();
        Vec3Impl nearCornerOffset = f.getWorldOffset(new Vec3Impl(1, -1, -1));
        Vec3Impl farCornerOffset = f.getWorldOffset(new Vec3Impl(-1, -2, 1));
        int offsetX_L = Math.min(nearCornerOffset.get0(), farCornerOffset.get0());
        int offsetY_L = Math.min(nearCornerOffset.get1(), farCornerOffset.get1());
        int offsetZ_L = Math.min(nearCornerOffset.get2(), farCornerOffset.get2());
        int offsetX_U = Math.max(nearCornerOffset.get0(), farCornerOffset.get0());
        int offsetY_U = Math.max(nearCornerOffset.get1(), farCornerOffset.get1());
        int offsetZ_U = Math.max(nearCornerOffset.get2(), farCornerOffset.get2());
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mMachine) {
                int z;
                int y;
                int x;
                ItemStack aStack = this.mInventory[1];
                BioCulture lCulture = null;
                if (aBaseMetaTileEntity.getTimer() % 200L == 0L) {
                    this.check_Chunk(offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
                }
                if (this.needsVisualUpdate && aBaseMetaTileEntity.getTimer() % 20L == 0L) {
                    for (x = offsetX_L; x <= offsetX_U; ++x) {
                        for (y = offsetY_L; y <= offsetY_U; ++y) {
                            for (z = offsetZ_L; z <= offsetZ_U; ++z) {
                                aBaseMetaTileEntity.getWorld().func_147468_f(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord());
                            }
                        }
                    }
                }
                this.height = this.reCalculateHeight();
                if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
                    if (!BWUtil.areStacksEqualOrNull(aStack, this.mStack) || this.needsVisualUpdate && aBaseMetaTileEntity.getTimer() % 20L == 1L) {
                        for (x = offsetX_L; x <= offsetX_U; ++x) {
                            for (y = offsetY_L; y <= offsetY_U; ++y) {
                                for (z = offsetZ_L; z <= offsetZ_U; ++z) {
                                    if (aStack != null && (!(aStack.func_77973_b() instanceof ItemLabParts) || aStack.func_77960_j() != 0) || this.mCulture != null && aStack != null && aStack.func_77978_p() != null && this.mCulture.getID() == aStack.func_77978_p().func_74762_e("ID")) continue;
                                    lCulture = aStack == null || aStack.func_77978_p() == null ? null : BioCulture.getBioCulture(aStack.func_77978_p().func_74779_i("Name"));
                                    this.sendPackagesOrRenewRenderer(x, y, z, lCulture);
                                }
                            }
                        }
                        this.mStack = aStack;
                        this.mCulture = lCulture;
                    }
                    if (this.needsVisualUpdate && aBaseMetaTileEntity.getTimer() % 20L == 1L) {
                        if (aBaseMetaTileEntity.isClientSide()) {
                            new Throwable().printStackTrace();
                        }
                        this.placeFluid(xDir, zDir, offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
                        this.needsVisualUpdate = false;
                    }
                }
            } else {
                this.onRemoval();
            }
        }
    }

    @Override
    public void onRemoval() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        ExtendedFacing f = this.getExtendedFacing();
        Vec3Impl nearCornerOffset = f.getWorldOffset(new Vec3Impl(1, -1, -1));
        Vec3Impl farCornerOffset = f.getWorldOffset(new Vec3Impl(-1, -2, 1));
        int offsetX_L = Math.min(nearCornerOffset.get0(), farCornerOffset.get0());
        int offsetY_L = Math.min(nearCornerOffset.get1(), farCornerOffset.get1());
        int offsetZ_L = Math.min(nearCornerOffset.get2(), farCornerOffset.get2());
        int offsetX_U = Math.max(nearCornerOffset.get0(), farCornerOffset.get0());
        int offsetY_U = Math.max(nearCornerOffset.get1(), farCornerOffset.get1());
        int offsetZ_U = Math.max(nearCornerOffset.get2(), farCornerOffset.get2());
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        if (this.isVisibleFluid) {
            this.removeFluid(xDir, zDir, offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
            this.sendRenderPackets(xDir, zDir, offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
        } else if (aBaseMetaTileEntity.getWorld().func_72820_D() % 20L == 7L) {
            this.sendRenderPackets(xDir, zDir, offsetX_L, offsetY_L, offsetZ_L, offsetX_U, offsetY_U, offsetZ_U);
        }
        super.onRemoval();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.height != this.reCalculateHeight()) {
            this.needsVisualUpdate = true;
        }
        this.doAllVisualThings();
        if (aBaseMetaTileEntity.isServerSide() && this.mRadHatches.size() == 1) {
            this.mSievert = this.mRadHatches.get(0).getSievert();
            if (aBaseMetaTileEntity.isActive() && this.mNeededSievert > this.mSievert) {
                this.mOutputFluids = null;
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && this.mMaxProgresstime <= 0) {
            this.mTimes = 0;
            this.mMaxProgresstime = 0;
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFluidHeight", this.height);
        if (this.mCulture != null && !this.mCulture.getName().isEmpty()) {
            aNBT.func_74778_a("mCulture", this.mCulture.getName());
        } else if ((this.mCulture == null || this.mCulture.getName().isEmpty()) && !aNBT.func_74779_i("mCulture").isEmpty()) {
            aNBT.func_82580_o("mCulture");
        }
        if (this.mFluid != null) {
            aNBT.func_74778_a("mFluid", this.mFluid.getName());
        }
        aNBT.func_74768_a("mSievert", this.mSievert);
        aNBT.func_74768_a("mNeededSievert", this.mNeededSievert);
        aNBT.func_74757_a("isVisibleFluid", this.isVisibleFluid);
        super.saveNBTData(aNBT);
    }

    private int getXDir() {
        return this.getBaseMetaTileEntity().getBackFacing().offsetX * 2;
    }

    private int getZDir() {
        return this.getBaseMetaTileEntity().getBackFacing().offsetZ * 2;
    }

    private void sendRenderPackets(int xDir, int zDir, int offsetX_L, int offsetY_L, int offsetZ_L, int offsetX_U, int offsetY_U, int offsetZ_U) {
        if (SideReference.Side.Server) {
            IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
            for (int x = offsetX_L; x <= offsetX_U; ++x) {
                for (int y = offsetY_L; y <= offsetY_U; ++y) {
                    for (int z = offsetZ_L; z <= offsetZ_U; ++z) {
                        GTValues.NW.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), new PacketBioVatRenderer(new Coords(xDir + x + aBaseMetaTileEntity.getXCoord(), y + aBaseMetaTileEntity.getYCoord(), zDir + z + aBaseMetaTileEntity.getZCoord(), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g), this.mCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : this.mCulture.getColorRGB(), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
                    }
                }
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.height = aNBT.func_74762_e("mFluidHeight");
        this.mCulture = BioCulture.getBioCulture(aNBT.func_74779_i("mCulture"));
        if (!aNBT.func_74779_i("mFluid").isEmpty()) {
            this.mFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mFluid"));
        }
        this.mSievert = aNBT.func_74762_e("mSievert");
        this.mNeededSievert = aNBT.func_74762_e("mNeededSievert");
        super.loadNBTData(aNBT);
        this.isVisibleFluid = aNBT.func_74767_n("isVisibleFluid");
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEBioVat(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public String[] getInfoData() {
        String[] baseInfoData = super.getInfoData();
        String[] infoData = new String[baseInfoData.length + 2];
        System.arraycopy(baseInfoData, 0, infoData, 0, baseInfoData.length);
        infoData[infoData.length - 2] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.expectedProduction") + ": " + EnumChatFormatting.GREEN + (this.mMachine ? (this.mMaxProgresstime <= 0 ? this.getExpectedMultiplier(null, false) : this.mExpectedMultiplier) * 100 : -1) + EnumChatFormatting.RESET + " %";
        infoData[infoData.length - 1] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.production") + ": " + EnumChatFormatting.GREEN + (this.mMaxProgresstime <= 0 ? 0 : this.mTimes) * 100 + EnumChatFormatting.RESET + " %";
        return infoData;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    private static enum RadioHatchElement implements IHatchElement<MTEBioVat>
    {
        RadioHatch((rec$, x$0, x$1) -> MTEBioVat.access$600((MTEBioVat)rec$, x$0, x$1), new Class[]{MTERadioHatch.class}){

            @Override
            public long count(MTEBioVat mteBioVat) {
                return mteBioVat.mRadHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEBioVat> adder;

        @SafeVarargs
        private RadioHatchElement(IGTHatchAdder<MTEBioVat> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEBioVat> adder() {
            return this.adder;
        }
    }
}

