/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.items;

import bartworks.MainMod;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemRockCutter
extends ItemTool
implements IElectricItem {
    private static Set<Block> mineableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150354_m, Blocks.field_150435_aG});
    private final int mCharge;
    private final int mTransfer;
    public int mTier;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;
    private final int multi;

    public ItemRockCutter(int aTier) {
        super((float)(2 * aTier), Item.ToolMaterial.EMERALD, mineableBlocks);
        this.mTier = aTier;
        this.multi = (int)GTUtility.powInt(10.0, this.mTier - 1);
        mineableBlocks = new HashSet<Block>();
        this.field_77777_bU = 1;
        this.mCharge = 10000 * this.multi;
        this.mTransfer = (int)GTValues.V[this.mTier];
        this.field_77864_a = 2.0f * (float)this.mTier;
        this.func_77637_a(MainMod.GT2);
        this.func_77656_e(27 + 10 * this.multi);
        this.setNoRepair();
        this.func_77655_b("GT_Rockcutter_Item_" + GTValues.VN[this.mTier]);
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        aList.add(StatCollector.func_74838_a((String)"tooltip.bw.tier.name") + " " + GTValues.VN[this.mTier]);
    }

    public void func_77663_a(ItemStack aStack, World worldIn, Entity entityIn, int p_77663_4_, boolean p_77663_5_) {
        if (!ElectricItem.manager.canUse(aStack, (double)(500 * this.multi))) {
            if (aStack.func_77948_v()) {
                aStack.func_77978_p().func_82580_o("ench");
            }
        } else if (!aStack.func_77948_v()) {
            aStack.func_77966_a(Enchantment.field_77348_q, 3);
        }
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        ElectricItem.manager.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        return false;
    }

    public boolean func_150894_a(ItemStack var1, World var2, Block var3, int var4, int var5, int var6, EntityLivingBase var7) {
        ElectricItem.manager.use(var1, 0.0, var7);
        if (ElectricItem.manager.canUse(var1, (double)(500 * this.multi))) {
            ElectricItem.manager.use(var1, (double)(500 * this.multi), var7);
        } else {
            ElectricItem.manager.discharge(var1, 2.147483647E9, Integer.MAX_VALUE, true, true, false);
        }
        return true;
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return par1Block.func_149688_o().equals(Material.field_151592_s) || par1Block.func_149688_o().equals(Material.field_151571_B) || par1Block.func_149688_o().equals(Material.field_151598_x) || par1Block.func_149688_o().equals(Material.field_151588_w) || par1Block.func_149688_o().equals(Material.field_151595_p) || par1Block.func_149688_o().equals(Material.field_151578_c) || par1Block.func_149688_o().equals(Material.field_151576_e) || mineableBlocks.contains(par1Block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List<ItemStack> itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.mCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.mTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.mTransfer;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("bartworks:GT_Rockcutter");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icon;
    }
}

