/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.main.config;

import codechicken.nei.NEIClientUtils;
import com.github.dcysteine.neicustomdiagram.main.Logger;

public enum DiagramGroupVisibility {
    ALWAYS_SHOWN{

        @Override
        public boolean isShown() {
            return true;
        }
    }
    ,
    ALWAYS_HIDDEN{

        @Override
        public boolean isShown() {
            return false;
        }
    }
    ,
    SHOW_ON_SHIFT{

        @Override
        public boolean isShown() {
            return NEIClientUtils.shiftKey();
        }
    }
    ,
    HIDE_ON_SHIFT{

        @Override
        public boolean isShown() {
            return !NEIClientUtils.shiftKey();
        }
    }
    ,
    SHOW_ON_CTRL{

        @Override
        public boolean isShown() {
            return NEIClientUtils.controlKey();
        }
    }
    ,
    HIDE_ON_CTRL{

        @Override
        public boolean isShown() {
            return !NEIClientUtils.controlKey();
        }
    }
    ,
    DISABLED{

        @Override
        public boolean isShown() {
            return false;
        }
    };


    public abstract boolean isShown();

    public static DiagramGroupVisibility getByName(String name) {
        try {
            return DiagramGroupVisibility.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            Logger.MOD.error("Could not find DiagramGroupVisibility: [{}]. Falling back to ALWAYS_SHOWN.", new Object[]{name});
            return ALWAYS_SHOWN;
        }
    }
}

