/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.fp;

import openmods.calc.IValuePrinter;
import openmods.calc.PositionalNotationPrinter;
import openmods.calc.PrinterUtils;
import openmods.config.simpler.Configurable;
import org.apache.commons.lang3.tuple.Pair;

public class DoublePrinter
implements IValuePrinter<Double> {
    private final PositionalNotationPrinter<Double> printer = new Helper(8);
    @Configurable
    public int base = 10;
    @Configurable
    public boolean allowStandardPrinter = false;
    @Configurable
    public boolean uniformBaseNotation = false;

    @Override
    public String str(Double value) {
        if (this.base == 10 && !this.allowStandardPrinter && !this.uniformBaseNotation) {
            return value.toString();
        }
        if (value.isNaN()) {
            return "NaN";
        }
        if (value.isInfinite()) {
            return value > 0.0 ? "+Inf" : "-Inf";
        }
        String result = this.printer.toString(value, this.base);
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, result);
    }

    @Override
    public String repr(Double value) {
        return this.str(value);
    }

    public static class Helper
    extends PositionalNotationPrinter<Double> {
        public Helper(int maxDigits) {
            super(maxDigits);
        }

        @Override
        protected Pair<Double, Double> splitNumber(Double value) {
            double integer = value.intValue();
            double fractional = value - integer;
            return Pair.of((Object)integer, (Object)fractional);
        }

        @Override
        protected PositionalNotationPrinter.IDigitProvider createIntegerDigitProvider(final Double value, final int radix) {
            return new PositionalNotationPrinter.IDigitProvider(){
                private int remainder;
                {
                    this.remainder = value.intValue();
                }

                @Override
                public int getNextDigit() {
                    int digit = this.remainder % radix;
                    this.remainder /= radix;
                    return digit;
                }

                @Override
                public boolean hasNextDigit() {
                    return this.remainder > 0;
                }
            };
        }

        @Override
        protected PositionalNotationPrinter.IDigitProvider createFractionalDigitProvider(final Double value, int radix) {
            final double doubleRadix = radix;
            return new PositionalNotationPrinter.IDigitProvider(){
                private double remainder;
                {
                    this.remainder = value;
                }

                @Override
                public int getNextDigit() {
                    this.remainder *= doubleRadix;
                    int result = (int)this.remainder;
                    this.remainder %= 1.0;
                    return result;
                }

                @Override
                public boolean hasNextDigit() {
                    return this.remainder > 0.0;
                }
            };
        }

        @Override
        protected boolean isNegative(Double value) {
            return value < 0.0;
        }

        @Override
        protected Double negate(Double value) {
            return -value.doubleValue();
        }

        @Override
        protected boolean isZero(Double value) {
            return value == 0.0;
        }
    }
}

