/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntityEggInfo;

public class TFCreatures {
    public static HashMap<Integer, TFEntityEggInfo> entityEggs = new LinkedHashMap<Integer, TFEntityEggInfo>();

    public static void registerTFCreature(Class<? extends Entity> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour) {
        TFCreatures.registerTFCreature(entityClass, entityName, id, backgroundEggColour, foregroundEggColour, 80, 3, true);
    }

    public static void registerTFCreature(Class<? extends Entity> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        if (TwilightForestMod.creatureCompatibility) {
            EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)id);
        }
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)TwilightForestMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        entityEggs.put(id, new TFEntityEggInfo(id, backgroundEggColour, foregroundEggColour));
    }

    public static void registerTFCreature(Class<? extends Entity> entityClass, String entityName, int id) {
        if (TwilightForestMod.creatureCompatibility) {
            EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)id);
        }
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)TwilightForestMod.instance, (int)80, (int)3, (boolean)true);
    }

    public static Entity createEntityByID(int entityID, World par1World) {
        Entity entity = null;
        try {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)TwilightForestMod.instance);
            EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, entityID);
            Class clazz = er.getEntityClass();
            if (clazz != null) {
                entity = (Entity)clazz.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (entity == null) {
            FMLLog.fine((String)("[TwilightForest] Skipping Entity with id " + entityID), (Object[])new Object[0]);
        }
        return entity;
    }

    public static String getStringFromID(int entityID) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)TwilightForestMod.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, entityID);
        if (er != null) {
            return er.getEntityName();
        }
        return null;
    }

    public static String getSpawnerNameFor(String baseName) {
        if (TwilightForestMod.creatureCompatibility) {
            return baseName;
        }
        return "TwilightForest." + baseName;
    }
}

