/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerIdentifier {
    private static final Map<UUID, PlayerIdentifier> idBased = new HashMap<UUID, PlayerIdentifier>();
    private static final Map<String, PlayerIdentifier> nameBased = new HashMap<String, PlayerIdentifier>();
    private String username;
    private UUID id;

    private PlayerIdentifier(String username, UUID id) {
        this.username = username;
        this.id = id;
    }

    public static PlayerIdentifier get(EntityPlayer player) {
        return PlayerIdentifier.get(player.func_146103_bH().getName(), player.func_146103_bH().getId());
    }

    public static PlayerIdentifier get(String username, UUID id) {
        if (idBased.containsKey(id)) {
            return idBased.get(id).setUsername(username);
        }
        if (nameBased.containsKey(username)) {
            return nameBased.get(username);
        }
        if (id != null) {
            PlayerIdentifier ident = new PlayerIdentifier(username, id);
            idBased.put(id, ident);
            return ident;
        }
        if (username == null) {
            throw new NullPointerException();
        }
        PlayerIdentifier ident = new PlayerIdentifier(username, id);
        nameBased.put(username, ident);
        return ident;
    }

    public void writeToNBT(NBTTagCompound nbt, String prefix) {
        if (this.id != null) {
            nbt.func_74778_a(prefix + "_id", this.id.toString());
        }
        nbt.func_74778_a(prefix + "_name", this.username);
    }

    public static PlayerIdentifier readFromNBT(NBTTagCompound nbt, String prefix) {
        UUID id = null;
        if (nbt.func_74764_b(prefix + "_id")) {
            String tmp = nbt.func_74779_i(prefix + "_id");
            try {
                id = UUID.fromString(tmp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String username = nbt.func_74779_i(prefix + "_name");
        return PlayerIdentifier.get(username, id);
    }

    public static PlayerIdentifier convertFromUsername(String name) {
        return PlayerIdentifier.get(name, null);
    }

    public String getAsString() {
        return this.id != null ? this.id.toString() : this.username;
    }

    public PlayerIdentifier setUsername(String string) {
        if (this.username == null || this.username.isEmpty()) {
            this.username = string;
        }
        return this;
    }

    public PlayerIdentifier setID(UUID uuid) {
        if (this.id == null) {
            this.id = uuid;
            idBased.put(this.id, this);
        }
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public UUID getId() {
        return this.id;
    }
}

