/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterManager;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.order.IDistanceTracker;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.SlidingWindowBitSet;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class LPTravelingItem {
    public static final Map<Integer, WeakReference<LPTravelingItemServer>> serverList = new HashMap<Integer, WeakReference<LPTravelingItemServer>>();
    public static final Map<Integer, WeakReference<LPTravelingItemClient>> clientList = new HashMap<Integer, WeakReference<LPTravelingItemClient>>();
    public static final List<Pair<Integer, Object>> forceKeep = new ArrayList<Pair<Integer, Object>>();
    public static final SlidingWindowBitSet clientSideKnownIDs = new SlidingWindowBitSet(20);
    private static int nextFreeId = 0;
    protected int id;
    protected float speed = 0.01f;
    public int lastTicked = 0;
    protected TileEntity container;
    protected float position = 0.0f;
    public ForgeDirection input = ForgeDirection.UNKNOWN;
    public ForgeDirection output = ForgeDirection.UNKNOWN;
    public final EnumSet<ForgeDirection> blacklist = EnumSet.noneOf(ForgeDirection.class);

    public LPTravelingItem() {
        this.id = this.getNextId();
    }

    public LPTravelingItem(int id, float position, ForgeDirection input, ForgeDirection output) {
        this.id = id;
        this.position = position;
        this.input = input;
        this.output = output;
    }

    public LPTravelingItem(int id) {
        this.id = id;
    }

    protected int getNextId() {
        return ++nextFreeId;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public float getPosition() {
        return this.position;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public int getId() {
        return this.id;
    }

    public abstract ItemIdentifierStack getItemIdentifierStack();

    public boolean isCorrupted() {
        return this.getItemIdentifierStack() == null || this.getItemIdentifierStack().getStackSize() <= 0;
    }

    public int getAge() {
        return 0;
    }

    public void addAge() {
    }

    public float getHoverStart() {
        return 0.0f;
    }

    public static final class LPTravelingItemServer
    extends LPTravelingItem
    implements IRoutedItem {
        private ItemRoutingInformation info;

        public LPTravelingItemServer(ItemIdentifierStack stack) {
            this.info = new ItemRoutingInformation();
            this.info.setItem(stack);
        }

        public LPTravelingItemServer(ItemRoutingInformation info) {
            this.info = info;
        }

        public LPTravelingItemServer(NBTTagCompound data) {
            this.info = new ItemRoutingInformation();
            this.readFromNBT(data);
        }

        @Override
        public ItemIdentifierStack getItemIdentifierStack() {
            return this.info.getItem();
        }

        public void setInformation(ItemRoutingInformation info) {
            this.info = info;
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            this.setPosition(data.func_74760_g("position"));
            this.setSpeed(data.func_74760_g("speed"));
            this.input = ForgeDirection.getOrientation((int)data.func_74762_e("input"));
            this.output = ForgeDirection.getOrientation((int)data.func_74762_e("output"));
            this.info.readFromNBT(data);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74776_a("position", this.getPosition());
            data.func_74776_a("speed", this.getSpeed());
            data.func_74768_a("input", this.input.ordinal());
            if (this.output != null) {
                data.func_74768_a("output", this.output.ordinal());
            }
            this.info.writeToNBT(data);
        }

        public EntityItem toEntityItem() {
            World worldObj = this.container.func_145831_w();
            if (MainProxy.isServer(worldObj)) {
                if (this.getItemIdentifierStack().getStackSize() <= 0) {
                    return null;
                }
                if (this.getItemIdentifierStack().makeNormalStack().func_77973_b() instanceof LogisticsFluidContainer) {
                    this.itemWasLost();
                    return null;
                }
                ForgeDirection exitdirection = this.output;
                if (exitdirection == ForgeDirection.UNKNOWN) {
                    exitdirection = this.input;
                }
                LPPosition position = new LPPosition((double)this.container.field_145851_c + 0.5, (double)this.container.field_145848_d + 0.375, (double)this.container.field_145849_e + 0.5);
                switch (exitdirection) {
                    case DOWN: {
                        position.moveForward(exitdirection, 0.5);
                        break;
                    }
                    case UP: {
                        position.moveForward(exitdirection, 0.75);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: 
                    case WEST: 
                    case EAST: {
                        position.moveForward(exitdirection, 0.625);
                        break;
                    }
                }
                LPPosition motion = new LPPosition(0, 0, 0);
                motion.moveForward(exitdirection, this.getSpeed() * 2.0f);
                EntityItem entityitem = this.getItemIdentifierStack().makeEntityItem(worldObj, position.getXD(), position.getYD(), position.getZD());
                float f3 = worldObj.field_73012_v.nextFloat() * 0.015f - 0.005f;
                entityitem.field_70159_w = (double)((float)worldObj.field_73012_v.nextGaussian() * f3) + motion.getXD();
                entityitem.field_70181_x = (double)((float)worldObj.field_73012_v.nextGaussian() * f3) + motion.getYD();
                entityitem.field_70179_y = (double)((float)worldObj.field_73012_v.nextGaussian() * f3) + motion.getZD();
                this.itemWasLost();
                return entityitem;
            }
            return null;
        }

        @Override
        public void clearDestination() {
            if (this.info.destinationint >= 0) {
                this.itemWasLost();
                this.info.jamlist.add(this.info.destinationint);
            }
            this.info.destinationint = -1;
            this.info.destinationUUID = null;
            this.info._doNotBuffer = false;
            this.info.arrived = false;
            this.info._transportMode = IRoutedItem.TransportMode.Unknown;
            this.info.targetInfo = null;
        }

        public void itemWasLost() {
            IRouter destinationRouter;
            if (this.container != null && MainProxy.isClient(this.container.func_145831_w())) {
                return;
            }
            if (this.info.destinationint >= 0 && SimpleServiceLocator.routerManager.isRouter(this.info.destinationint) && (destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.info.destinationint)).getPipe() != null) {
                destinationRouter.getPipe().notifyOfReroute(this.info);
                if (destinationRouter.getPipe() instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)destinationRouter.getPipe())).itemLost(this.info.getItem().clone(), this.info.targetInfo);
                }
                if (destinationRouter.getPipe() instanceof IRequireReliableFluidTransport && this.info.getItem().getItem().isFluidContainer()) {
                    FluidStack liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(this.info.getItem());
                    ((IRequireReliableFluidTransport)((Object)destinationRouter.getPipe())).liquidLost(FluidIdentifier.get(liquid), liquid.amount);
                }
            }
        }

        @Override
        public int getDestination() {
            return this.info.destinationint;
        }

        @Override
        public void setDestination(int destination) {
            this.info.destinationint = destination;
            IRouter router = SimpleServiceLocator.routerManager.getRouter(destination);
            this.info.destinationUUID = router != null ? router.getId() : null;
        }

        @Override
        public void setDoNotBuffer(boolean isBuffered) {
            this.info._doNotBuffer = isBuffered;
        }

        @Override
        public boolean getDoNotBuffer() {
            return this.info._doNotBuffer;
        }

        @Override
        public void setArrived(boolean flag) {
            this.info.arrived = flag;
        }

        @Override
        public boolean getArrived() {
            return this.info.arrived;
        }

        @Override
        public void split(int itemsToTake, ForgeDirection orientation) {
            if (this.getItemIdentifierStack().getItem().isFluidContainer()) {
                throw new UnsupportedOperationException("Can't split up a FluidContainer");
            }
            ItemIdentifierStack stackToKeep = this.getItemIdentifierStack();
            ItemIdentifierStack stackToSend = stackToKeep.clone();
            stackToKeep.setStackSize(itemsToTake);
            stackToSend.setStackSize(stackToSend.getStackSize() - itemsToTake);
            this.newId();
            LPTravelingItemServer newItem = new LPTravelingItemServer(stackToSend);
            newItem.setSpeed(this.getSpeed());
            newItem.setTransportMode(this.getTransportMode());
            newItem.setDestination(this.getDestination());
            newItem.clearDestination();
            if (this.container instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)this.container).pipe.transport instanceof PipeTransportLogistics) {
                ((LogisticsTileGenericPipe)this.container).pipe.transport.injectItem((LPTravelingItem)newItem, orientation);
            }
        }

        @Override
        public void setTransportMode(IRoutedItem.TransportMode transportMode) {
            this.info._transportMode = transportMode;
        }

        @Override
        public IRoutedItem.TransportMode getTransportMode() {
            return this.info._transportMode;
        }

        @Override
        public void addToJamList(IRouter router) {
            this.info.jamlist.add(router.getSimpleID());
        }

        @Override
        public List<Integer> getJamList() {
            return this.info.jamlist;
        }

        @Override
        public int getBufferCounter() {
            return this.info.bufferCounter;
        }

        @Override
        public void setBufferCounter(int counter) {
            this.info.bufferCounter = counter;
        }

        @Override
        public UUID getDestinationUUID() {
            return this.info.destinationUUID;
        }

        @Override
        public void checkIDFromUUID() {
            IRouterManager rm = SimpleServiceLocator.routerManager;
            IRouter router = rm.getRouter(this.info.destinationint);
            if (router == null || this.info.destinationUUID != router.getId()) {
                this.info.destinationint = rm.getIDforUUID(this.info.destinationUUID);
            }
        }

        public void refreshDestinationInformation() {
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.info.destinationint);
            if (destinationRouter != null && destinationRouter.getPipe() instanceof CoreRoutedPipe) {
                destinationRouter.getPipe().refreshItem(this.getInfo());
            }
        }

        @Override
        public void setDistanceTracker(IDistanceTracker tracker) {
            this.info.tracker = tracker;
        }

        @Override
        public IDistanceTracker getDistanceTracker() {
            return this.info.tracker;
        }

        public void resetDelay() {
            this.info.resetDelay();
        }

        @Override
        public void setAdditionalTargetInformation(IAdditionalTargetInformation targetInfo) {
            this.info.targetInfo = targetInfo;
        }

        @Override
        public IAdditionalTargetInformation getAdditionalTargetInformation() {
            return this.info.targetInfo;
        }

        public void newId() {
            this.id = this.getNextId();
        }

        @Override
        public ItemRoutingInformation getInfo() {
            return this.info;
        }
    }

    public static final class LPTravelingItemClient
    extends LPTravelingItem {
        private ItemIdentifierStack item;

        public LPTravelingItemClient(int id, float position, ForgeDirection input, ForgeDirection output) {
            super(id, position, input, output);
        }

        public LPTravelingItemClient(int id, ItemIdentifierStack stack) {
            super(id);
            this.item = stack;
        }

        @Override
        public ItemIdentifierStack getItemIdentifierStack() {
            return this.item;
        }

        public void updateInformation(ForgeDirection input, ForgeDirection output, float speed, float position) {
            this.input = input;
            this.output = output;
            this.speed = speed;
            this.position = position;
        }

        @Override
        public int getAge() {
            return 0;
        }

        @Override
        public void addAge() {
        }

        @Override
        public float getHoverStart() {
            return 0.0f;
        }

        public void setItem(ItemIdentifierStack item) {
            this.item = item;
        }
    }
}

