/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.robots.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import java.util.Iterator;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.robots.boards.LogisticsRoutingBoardRobot;
import logisticspipes.transport.LPTravelingItem;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemInsertionAIRobot
extends AIRobot {
    private final LogisticsTileGenericPipe pipe;
    private final LogisticsRoutingBoardRobot board;
    private final ForgeDirection insertion;
    private IInventoryUtil robotInv;
    private int tick = 0;

    public ItemInsertionAIRobot(EntityRobotBase iRobot, LogisticsTileGenericPipe pipe, LogisticsRoutingBoardRobot board, ForgeDirection insertion) {
        super(iRobot);
        this.pipe = pipe;
        this.board = board;
        this.insertion = insertion;
    }

    public void start() {
        if (this.pipe == null || this.board == null) {
            this.terminate();
            return;
        }
        this.robotInv = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil((IInventory)this.robot, ForgeDirection.UNKNOWN);
        if (this.robotInv == null) {
            this.terminate();
        }
    }

    public void update() {
        if (this.tick++ % 2 == 0) {
            Iterator<LPTravelingItem.LPTravelingItemServer> iter = this.board.getItems().iterator();
            if (iter.hasNext()) {
                LPTravelingItem.LPTravelingItemServer item = iter.next();
                LPTravelingItem.clientSideKnownIDs.set(item.getId(), false);
                this.pipe.pipe.transport.injectItem(item, this.insertion);
                this.robotInv.getMultipleItems(item.getItemIdentifierStack().getItem(), item.getItemIdentifierStack().getStackSize());
                iter.remove();
            } else {
                this.terminate();
            }
        }
    }

    public boolean success() {
        return this.board.getItems().isEmpty();
    }
}

