/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.api.core.BCLog;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.utils.ThreadSafeUtils;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BuildCraftMod {
    private static PacketSender sender = new PacketSender();
    private static Thread senderThread = new Thread(sender);
    public EnumMap<Side, FMLEmbeddedChannel> channels;

    public void sendToPlayers(Packet packet, World world, int x, int y, int z, int maxDistance) {
        sender.add(new LocationSendRequest(this, packet, world.field_73011_w.field_76574_g, x, y, z, maxDistance));
    }

    public void sendToPlayersNear(Packet packet, TileEntity tileEntity, int maxDistance) {
        sender.add(new LocationSendRequest(this, packet, tileEntity.func_145831_w().field_73011_w.field_76574_g, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, maxDistance));
    }

    public void sendToPlayersNear(Packet packet, TileEntity tileEntity) {
        this.sendToPlayersNear(packet, tileEntity, DefaultProps.NETWORK_UPDATE_RANGE);
    }

    public void sendToWorld(Packet packet, World world) {
        sender.add(new WorldSendRequest(this, packet, world.field_73011_w.field_76574_g));
    }

    public void sendToEntity(Packet packet, Entity entity) {
        sender.add(new EntitySendRequest(this, packet, entity));
    }

    public void sendToPlayer(EntityPlayer entityplayer, Packet packet) {
        sender.add(new PlayerSendRequest(this, packet, entityplayer));
    }

    public void sendToServer(Packet packet) {
        try {
            this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        senderThread.setDaemon(true);
        senderThread.setName("BuildCraft packet sender thread");
        senderThread.start();
    }

    static class PacketSender
    implements Runnable {
        private BlockingQueue<SendRequest> packets = new LinkedBlockingQueue<SendRequest>();

        PacketSender() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        SendRequest r = this.packets.take();
                        net.minecraft.network.Packet p = ThreadSafeUtils.generatePacketFrom(r.packet, r.source.channels.get(Side.SERVER));
                        List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
                        EntityPlayerMP[] entityPlayerMPArray = playerList.toArray(new EntityPlayerMP[playerList.size()]);
                        int n = entityPlayerMPArray.length;
                        int n2 = 0;
                        while (true) {
                            NetworkManager manager;
                            NetHandlerPlayServer handler;
                            if (n2 >= n) continue block3;
                            EntityPlayerMP player = entityPlayerMPArray[n2];
                            if (r.isValid((EntityPlayer)player) && (handler = player.field_71135_a) != null && (manager = handler.field_147371_a) != null && manager.func_150724_d()) {
                                manager.func_150725_a(p, new GenericFutureListener[0]);
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    BCLog.logger.error("The BuildCraft packet sender thread raised an exception! Please report to GitHub.");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public boolean add(SendRequest r) {
            return this.packets.offer(r);
        }
    }

    class LocationSendRequest
    extends SendRequest {
        final int dimensionId;
        final int x;
        final int y;
        final int z;
        final int md;

        LocationSendRequest(BuildCraftMod source, Packet packet, int dimensionId, int x, int y, int z, int md) {
            super(source, packet);
            this.dimensionId = dimensionId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.md = md * md;
        }

        @Override
        boolean isValid(EntityPlayer player) {
            return this.dimensionId == player.field_70170_p.field_73011_w.field_76574_g && player.func_70092_e((double)this.x, (double)this.y, (double)this.z) <= (double)this.md;
        }
    }

    class WorldSendRequest
    extends SendRequest {
        final int dimensionId;

        WorldSendRequest(BuildCraftMod source, Packet packet, int dimensionId) {
            super(source, packet);
            this.dimensionId = dimensionId;
        }

        @Override
        boolean isValid(EntityPlayer player) {
            return player.field_70170_p.field_73011_w.field_76574_g == this.dimensionId;
        }
    }

    class EntitySendRequest
    extends SendRequest {
        Entity entity;

        EntitySendRequest(BuildCraftMod source, Packet packet, Entity entity) {
            super(source, packet);
            this.entity = entity;
        }

        @Override
        boolean isValid(EntityPlayer player) {
            if (player.field_70170_p.equals(this.entity.field_70170_p)) {
                if (player.field_70170_p instanceof WorldServer) {
                    return ((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers(this.entity).contains(player);
                }
                return true;
            }
            return false;
        }
    }

    class PlayerSendRequest
    extends SendRequest {
        EntityPlayer player;

        PlayerSendRequest(BuildCraftMod source, Packet packet, EntityPlayer player) {
            super(source, packet);
            this.player = player;
        }

        @Override
        boolean isValid(EntityPlayer player) {
            return this.player.equals((Object)player);
        }
    }

    static abstract class SendRequest {
        final Packet packet;
        final BuildCraftMod source;

        SendRequest(BuildCraftMod source, Packet packet) {
            this.packet = packet;
            this.source = source;
        }

        abstract boolean isValid(EntityPlayer var1);
    }
}

