/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.mixins.early.minecraft;

import com.gtnewhorizons.neid.NEIDConfig;
import com.gtnewhorizons.neid.mixins.interfaces.IExtendedBlockStorageMixin;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ExtendedBlockStorage.class})
public class MixinExtendedBlockStorage
implements IExtendedBlockStorageMixin {
    @Shadow
    private int field_76682_b;
    @Shadow
    private int field_76683_c;
    private short[] block16BArray = new short[4096];
    private short[] block16BMetaArray = new short[4096];

    @Override
    public short[] getBlock16BArray() {
        return this.block16BArray;
    }

    @Override
    public short[] getBlock16BMetaArray() {
        return this.block16BMetaArray;
    }

    @Override
    public byte[] getBlockData() {
        byte[] ret = new byte[this.block16BArray.length * 2];
        ByteBuffer.wrap(ret).asShortBuffer().put(this.block16BArray);
        return ret;
    }

    @Override
    public byte[] getBlockMeta() {
        byte[] ret = new byte[this.block16BMetaArray.length * 2];
        ByteBuffer.wrap(ret).asShortBuffer().put(this.block16BMetaArray);
        return ret;
    }

    @Override
    public void setBlockData(byte[] data, int offset) {
        ShortBuffer.wrap(this.block16BArray).put(ByteBuffer.wrap(data, offset, 8192).asShortBuffer());
    }

    @Override
    public void setBlockMeta(byte[] data, int offset) {
        ShortBuffer.wrap(this.block16BMetaArray).put(ByteBuffer.wrap(data, offset, 8192).asShortBuffer());
    }

    private int getBlockId(int x, int y, int z) {
        return this.block16BArray[y << 8 | z << 4 | x] & 0xFFFF;
    }

    private void setBlockId(int x, int y, int z, int id) {
        this.block16BArray[y << 8 | z << 4 | x] = (short)id;
    }

    @Overwrite
    public Block func_150819_a(int x, int y, int z) {
        return Block.func_149729_e((int)this.getBlockId(x, y, z));
    }

    @Overwrite
    public int func_76665_b(int x, int y, int z) {
        return this.block16BMetaArray[y << 8 | z << 4 | x] & 0xFFFF;
    }

    @Overwrite
    public void func_150818_a(int x, int y, int z, Block b) {
        Block old = this.func_150819_a(x, y, z);
        if (old != Blocks.field_150350_a) {
            --this.field_76682_b;
            if (old.func_149653_t()) {
                --this.field_76683_c;
            }
        }
        if (b != Blocks.field_150350_a) {
            ++this.field_76682_b;
            if (b.func_149653_t()) {
                ++this.field_76683_c;
            }
        }
        int newId = Block.func_149682_b((Block)b);
        if (NEIDConfig.CatchUnregisteredBlocks && newId == -1) {
            throw new IllegalArgumentException("Block " + b + " is not registered. <-- Say about this to the author of this mod, or you can try to enable \"RemoveInvalidBlocks\" option in NEID config.");
        }
        if ((newId < 0 || newId > Short.MAX_VALUE) && newId != -1) {
            throw new IllegalArgumentException("id out of range: " + newId);
        }
        if (newId == -1) {
            newId = Block.func_149682_b((Block)old);
        }
        this.setBlockId(x, y, z, newId);
    }

    @Overwrite
    public void func_76654_b(int x, int y, int z, int meta) {
        this.block16BMetaArray[y << 8 | z << 4 | x] = (short)(meta & 0xFFFF);
    }

    @Overwrite
    public void func_76672_e() {
        for (int off = 0; off < this.block16BArray.length; ++off) {
            int id = this.block16BArray[off] & 0xFFFF;
            if (id <= 0) continue;
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            if (block == null) {
                if (!NEIDConfig.RemoveInvalidBlocks) continue;
                this.block16BArray[off] = 0;
                continue;
            }
            if (block == Blocks.field_150350_a) continue;
            ++this.field_76682_b;
            if (!block.func_149653_t()) continue;
            ++this.field_76683_c;
        }
    }
}

