/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import pl.asie.computronics.Computronics;

public class LocomotiveManager {
    private final Map<UUID, EntityLocomotiveElectric> carts = new MapMaker().weakValues().makeMap();

    public static LocomotiveManager instance() {
        return Computronics.railcraft.manager;
    }

    public void removeLinkageId(EntityLocomotiveElectric loco) {
        this.carts.remove(this.getLinkageId(loco));
    }

    public UUID getLinkageId(EntityLocomotiveElectric loco) {
        UUID id = loco.getPersistentID();
        if (!this.isUnloaded(loco)) {
            this.carts.put(id, loco);
        }
        return id;
    }

    private void addLocomotive(EntityLocomotiveElectric loco) {
        UUID id = loco.getPersistentID();
        if (!this.isUnloaded(loco)) {
            this.carts.put(id, loco);
        }
    }

    public EntityLocomotiveElectric getCartFromUUID(UUID id) {
        EntityLocomotiveElectric cart = this.carts.get(id);
        if (cart != null && this.isUnloaded(cart)) {
            this.carts.remove(id);
            return null;
        }
        return this.carts.get(id);
    }

    private boolean isUnloaded(EntityLocomotiveElectric cart) {
        if (cart == null || cart.field_70128_L || cart.field_70170_p == null) {
            return true;
        }
        int x = MathHelper.func_76128_c((double)cart.field_70165_t);
        int z = MathHelper.func_76128_c((double)cart.field_70161_v);
        boolean isForced = cart.field_70170_p.getPersistentChunks().containsKey((Object)new ChunkCoordIntPair(x >> 4, z >> 4));
        int searchRange = isForced ? 0 : 32;
        boolean isLoaded = cart.field_70170_p.func_72904_c(x - searchRange, 0, z - searchRange, x + searchRange, 0, z + searchRange);
        if (!isLoaded) {
            EntityEvent.CanUpdate event = new EntityEvent.CanUpdate((Entity)cart);
            MinecraftForge.EVENT_BUS.post((Event)event);
            isLoaded = event.canUpdate;
        }
        return !isLoaded;
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.minecart;
        if (!(cart instanceof EntityLocomotiveElectric)) {
            return;
        }
        EntityLocomotiveElectric loco = (EntityLocomotiveElectric)cart;
        if (loco.field_70128_L) {
            this.removeLinkageId(loco);
        } else {
            this.addLocomotive(loco);
        }
    }
}

