/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.compatability;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;

public class IGWSupportNotifier {
    private String supportingMod;
    private static final String LATEST_DL_URL = "http://minecraft.curseforge.com/mc-mods/223815-in-game-wiki-mod/files/latest";

    public IGWSupportNotifier() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && !Loader.isModLoaded((String)"IGWMod")) {
            File dir = new File(".", "config");
            Configuration config = new Configuration(new File(dir, "IGWMod.cfg"));
            config.load();
            if (config.get("general", "enable_missing_notification", true, "When enabled, this will notify players when IGW-Mod is not installed even though mods add support.").getBoolean()) {
                ModContainer mc = Loader.instance().activeModContainer();
                String modid = mc.getModId();
                List loadedMods = Loader.instance().getActiveModList();
                for (ModContainer container : loadedMods) {
                    if (!container.getModId().equals(modid)) continue;
                    this.supportingMod = container.getName();
                    FMLCommonHandler.instance().bus().register((Object)this);
                    ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDownloadIGW());
                    break;
                }
            }
            config.save();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.player == FMLClientHandler.instance().getClientPlayerEntity()) {
            event.player.func_146105_b(IChatComponent.Serializer.func_150699_a((String)("[\"" + EnumChatFormatting.GOLD + "The mod " + this.supportingMod + " is supporting In-Game Wiki mod. " + EnumChatFormatting.GOLD + "However, In-Game Wiki isn't installed! [\",{\"text\":\"Download Latest\",\"color\":\"green\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/igwmod_download\"}},\"]\"]")));
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }

    private class CommandDownloadIGW
    extends CommandBase {
        private CommandDownloadIGW() {
        }

        public int func_82362_a() {
            return -100;
        }

        public String func_71517_b() {
            return "igwmod_download";
        }

        public String func_71518_a(ICommandSender sender) {
            return this.func_71517_b();
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            new ThreadDownloadIGW();
        }
    }

    private class ThreadDownloadIGW
    extends Thread {
        public ThreadDownloadIGW() {
            this.setName("IGW-Mod Download Thread");
            this.start();
        }

        @Override
        public void run() {
            try {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Downloading IGW-Mod..."));
                }
                URL url = new URL(IGWSupportNotifier.LATEST_DL_URL);
                URLConnection connection = url.openConnection();
                connection.connect();
                String fileName = "IGW-Mod.jar";
                File dir = new File(".", "mods");
                File f = new File(dir, fileName);
                FileUtils.copyURLToFile((URL)url, (File)f);
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Successfully downloaded. Restart Minecraft to apply."));
                }
                Desktop.getDesktop().open(dir);
                this.finalize();
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Failed to download"));
                }
                try {
                    this.finalize();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

