/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.util;

import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.util.CustomLadderRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;

public class CatwalkOptions {
    public boolean fullBlockLadder = false;
    public float ladderSpeedMultiplier = 1.0f;
    public float speedPotionLevel = 1.0f;
    public boolean vanillaLadders = false;
    public boolean altGrateRecipe = false;

    public void init() {
    }

    public void load(Configuration config) {
        config.load();
        this.fullBlockLadder = config.getBoolean("FullBlockLadder", "catwalks", this.fullBlockLadder, "Set to true to be able to climb the outside of caged ladders");
        this.ladderSpeedMultiplier = config.getFloat("ladderSpeed", "catwalks", this.ladderSpeedMultiplier, 0.0f, 10.0f, "Ladders will go at 5*N blocks/second");
        this.speedPotionLevel = config.getFloat("catwalkSpeed", "catwalks", this.speedPotionLevel, 0.0f, 10.0f, "Catwalk speed boost will be equivalent to a Speed N potion.");
        this.vanillaLadders = config.getBoolean("VanillaLadders", "catwalks", this.vanillaLadders, "Set to true to turn leaves, bookcases, and iron bars into ladders");
        this.altGrateRecipe = config.getBoolean("AlternateSteelGrateRecipe", "catwalks", this.altGrateRecipe, "Use alternate steel grate recipe with iron bars (in case of mod conflicts)");
        config.save();
    }

    public void postInit() {
        if (this.vanillaLadders) {
            this.initCustomLadders();
        }
    }

    public void initCustomLadders() {
        CustomLadderRegistry.registerCustomLadder(Blocks.field_150411_aY, new ICustomLadder(){

            @Override
            public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.1;
            }

            @Override
            public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return -1.0;
            }

            @Override
            public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                Block b = world.func_147439_a(x, y, z);
                if (!(b instanceof BlockPane)) {
                    return false;
                }
                BlockPane bp = (BlockPane)b;
                double d = 0.375;
                double dNorth = bp.canPaneConnectTo(world, x, y, z - 1, ForgeDirection.NORTH) ? 0.0 : d;
                double dSouth = bp.canPaneConnectTo(world, x, y, z + 1, ForgeDirection.SOUTH) ? 0.0 : d;
                double dEast = bp.canPaneConnectTo(world, x + 1, y, z, ForgeDirection.EAST) ? 0.0 : d;
                double dWest = bp.canPaneConnectTo(world, x - 1, y, z, ForgeDirection.WEST) ? 0.0 : d;
                AxisAlignedBB northSouthBox = AxisAlignedBB.func_72330_a((double)((double)x + d), (double)y, (double)((double)z + dNorth), (double)((double)(x + 1) - d), (double)(y + 1), (double)((double)(z + 1) - dSouth));
                AxisAlignedBB eastWestBox = AxisAlignedBB.func_72330_a((double)((double)x + dWest), (double)y, (double)((double)z + d), (double)((double)(x + 1) - dEast), (double)(y + 1), (double)((double)(z + 1) - d));
                return entity.field_70121_D.func_72326_a(northSouthBox) || entity.field_70121_D.func_72326_a(eastWestBox);
            }

            @Override
            public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
                return !isMovingDown;
            }

            @Override
            public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return entity.func_70093_af();
            }

            @Override
            public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return false;
            }

            @Override
            public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.0;
            }
        });
        ICustomLadder leafLadder = new ICustomLadder(){

            @Override
            public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.05;
            }

            @Override
            public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return -1.0;
            }

            @Override
            public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return true;
            }

            @Override
            public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
                return !isMovingDown;
            }

            @Override
            public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return entity.func_70093_af();
            }

            @Override
            public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return false;
            }

            @Override
            public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.0;
            }
        };
        CustomLadderRegistry.registerCustomLadder((Block)Blocks.field_150362_t, leafLadder);
        CustomLadderRegistry.registerCustomLadder((Block)Blocks.field_150361_u, leafLadder);
        CustomLadderRegistry.registerCustomLadder(Blocks.field_150342_X, new ICustomLadder(){

            @Override
            public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.05;
            }

            @Override
            public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return -1.0;
            }

            @Override
            public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return true;
            }

            @Override
            public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
                return !isMovingDown;
            }

            @Override
            public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return entity.func_70093_af();
            }

            @Override
            public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return false;
            }

            @Override
            public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
                return 0.0;
            }
        });
    }
}

