/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static String[] defaultPresets = Arrays.copyOf(Defaults.defaultPresets, Defaults.defaultPresets.length);
    public static HashSet<String> allowedBlocks = new HashSet<String>(Arrays.asList(Defaults.allowedBlocks));
    public static HashSet<String> allowedBiomes = new HashSet<String>(Arrays.asList(Defaults.allowedBiomes));
    public static int firstDimensionId = 180;
    public static boolean debugLogging = false;
    public static boolean useBlockEventChecks = true;

    public static void synchronizeConfiguration(File configFile) {
        Configuration configuration = new Configuration(configFile);
        configuration.load();
        defaultPresets = configuration.getStringList("general", "defaultPresets", Defaults.defaultPresets, "Default world configuration presets. Format: blockname*layers;blockname*layers;..., example preset: minecraft:bedrock;minecraft:dirt*3;minecraft:grass");
        allowedBlocks = new HashSet<String>(Arrays.asList(configuration.getStringList("general", "allowedBlocks", Defaults.allowedBlocks, "List of blocks allowed in the user-specified presets, keep in mind these are used in world generation, so will be available in infinite quantities for the player.")));
        allowedBiomes = Arrays.stream(configuration.getStringList("general", "allowedBiomes", Defaults.allowedBiomes, "List of biomes allowed for the personal dimensions.")).map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
        firstDimensionId = configuration.getInt("firstDimensionId", "general", 180, 0, Integer.MAX_VALUE, "First dimension ID to use for newly generated worlds");
        debugLogging = configuration.getBoolean("debugLogging", "general", false, "Debug logging toggle");
        useBlockEventChecks = configuration.getBoolean("useBlockEventChecks", "general", true, "Use fake Block break events to check for permissions, disable in case of broken event handlers");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static class Categories {
        public static final String general = "general";

        private Categories() {
        }
    }

    private static class Defaults {
        public static final String[] defaultPresets = new String[]{"", "minecraft:bedrock;minecraft:dirt*3;minecraft:grass", "minecraft:bedrock*4;minecraft:stone*58;minecraft:dirt;minecraft:grass"};
        public static final String[] allowedBlocks = new String[]{"minecraft:air", "minecraft:bedrock", "minecraft:stone", "minecraft:cobblestone", "minecraft:dirt", "minecraft:grass", "minecraft:double_stone_slab", "minecraft:netherrack"};
        public static final String[] allowedBiomes = new String[]{"Plains", "Ocean", "Desert", "Extreme Hills", "Forest", "Taiga", "Swampland", "River", "MushroomIsland", "Swampland", "Jungle", "Savanna", "Mesa"};
        public static final int firstDimensionId = 180;
        public static final boolean debugLogging = false;
        public static final boolean useBlockEventChecks = true;

        private Defaults() {
        }
    }
}

