/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat;

import buildcraft.BuildCraftCompat;
import buildcraft.api.transport.IInjectable;
import buildcraft.compat.CompatModuleFactorization;
import buildcraft.compat.bluepower.BPPneumaticTubeInjectable;
import buildcraft.compat.cofh.ItemDuctInjectable;
import buildcraft.compat.enderio.ItemConduitInjectable;
import buildcraft.core.CompatHooks;
import cofh.api.transport.IItemDuct;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.part.tube.PneumaticTube;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.item.IItemConduit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public class CompatHooksImpl
extends CompatHooks {
    public IInjectable getInjectableWrapper(TileEntity tile, ForgeDirection from) {
        if (tile == null) {
            return null;
        }
        IInjectable wrapper = null;
        if (wrapper == null && Loader.isModLoaded((String)"bluepower")) {
            wrapper = this.getInjectableBluePower(tile);
        }
        if (wrapper == null && Loader.isModLoaded((String)"EnderIO")) {
            wrapper = this.getInjectableEnderIO(tile);
        }
        if (wrapper == null && tile instanceof IItemDuct) {
            wrapper = new ItemDuctInjectable((IItemDuct)tile);
        }
        return wrapper;
    }

    @Optional.Method(modid="bluepower")
    public IInjectable getInjectableBluePower(TileEntity tile) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder((World)tile.func_145831_w(), (int)tile.field_145851_c, (int)tile.field_145848_d, (int)tile.field_145849_e);
        if (holder != null) {
            for (IPart p : holder.getParts()) {
                if (!(p instanceof PneumaticTube)) continue;
                return new BPPneumaticTubeInjectable((IPneumaticTube)((PneumaticTube)p).getLogic());
            }
        }
        return null;
    }

    @Optional.Method(modid="EnderIO")
    public IInjectable getInjectableEnderIO(TileEntity tile) {
        IConduitBundle bundle;
        IItemConduit conduit;
        if (tile instanceof IConduitBundle && (conduit = (IItemConduit)(bundle = (IConduitBundle)tile).getConduit(IItemConduit.class)) != null) {
            return new ItemConduitInjectable((IItemDuct)conduit);
        }
        return null;
    }

    public Object getEnergyProvider(TileEntity tile) {
        Object output;
        if (BuildCraftCompat.hasModule("factorization") && (output = CompatModuleFactorization.getEnergyProvider(tile)) != null) {
            return output;
        }
        return tile;
    }
}

