/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.dries007.holoInventory.client.Renderer;
import net.dries007.holoInventory.util.NamedData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EntityInventoryMessage
implements IMessage {
    NBTTagCompound data;

    public EntityInventoryMessage(NBTTagCompound inventoryData) {
        this.data = inventoryData;
    }

    public EntityInventoryMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<EntityInventoryMessage, IMessage> {
        public IMessage onMessage(EntityInventoryMessage message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                NBTTagList list = message.data.func_150295_c("list", 10);
                ItemStack[] itemStacks = new ItemStack[list.func_74745_c()];
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    itemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag);
                    if (itemStacks[i] == null) continue;
                    itemStacks[i].field_77994_a = tag.func_74762_e("Count");
                }
                if (message.data.func_74764_b("class")) {
                    Renderer.entityMap.put(message.data.func_74762_e("id"), new NamedData<ItemStack[]>(message.data.func_74779_i("name"), message.data.func_74779_i("class"), itemStacks));
                } else {
                    Renderer.entityMap.put(message.data.func_74762_e("id"), new NamedData<ItemStack[]>(message.data.func_74779_i("name"), itemStacks));
                }
            }
            return null;
        }
    }
}

