/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common;

import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import com.cleanroommc.modularui.utils.item.PlayerMainInvWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class McUtils {
    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        McUtils.dropItem(stack, world, x, y, z, null, false, 10);
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z, @Nullable String thrower, boolean noDespawn, int pickUpDelay) {
        if (!world.field_72995_K && stack != null && !world.restoringBlockSnapshots) {
            double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(world, x + d0, y + d1, z + d2, stack);
            entityitem.field_145804_b = pickUpDelay;
            entityitem.func_145799_b(thrower);
            if (noDespawn) {
                entityitem.field_70292_b = -6000;
            }
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void giveItemsToPlayer(EntityPlayer player, List<ItemStack> items) {
        if (player == null || items.isEmpty()) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Should only be called from server side!");
        }
        PlayerMainInvWrapper itemHandler = new PlayerMainInvWrapper(player.field_71071_by);
        items.removeIf(item -> {
            ItemStack remainder = McUtils.insertToPlayer(itemHandler, item, false);
            return remainder == null;
        });
        for (ItemStack item2 : items) {
            player.func_146097_a(item2, false, false);
        }
    }

    public static ItemStack insertToPlayer(PlayerMainInvWrapper itemHandler, ItemStack stack, boolean simulate) {
        ItemStack slot;
        if (itemHandler == null || stack == null) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return McUtils.insertItem((IItemHandler)itemHandler, stack, simulate, 9);
        }
        int sizeInventory = itemHandler.getSlots();
        for (int i = 9; !(i >= sizeInventory || ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)(slot = itemHandler.getStackInSlot(i)), (ItemStack)stack) && (stack = itemHandler.insertItem(i, stack, simulate)) == null); ++i) {
        }
        return McUtils.insertItem((IItemHandler)itemHandler, stack, simulate, 9);
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int startSlot) {
        if (dest == null || stack == null) {
            return stack;
        }
        for (int i = startSlot; i < dest.getSlots(); ++i) {
            if ((stack = dest.insertItem(i, stack, simulate)) != null) continue;
            return null;
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSound(String sound) {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        ResourceLocation resourceLocation = new ResourceLocation(sound);
        PositionedSoundRecord record = PositionedSoundRecord.func_147674_a((ResourceLocation)resourceLocation, (float)1.0f);
        soundHandler.func_147682_a((ISound)record);
    }

    public static boolean areItemsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        return stackA != null && stackB != null ? McUtils.isItemEqualIgnoreDurability(stackA, stackB) : false;
    }

    public static boolean isItemEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (!stackA.func_77984_f()) {
            return stackA.func_77969_a(stackB);
        }
        return stackA != null && stackB != null && stackA.field_151002_e == stackB.field_151002_e;
    }
}

