/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.entity.spaceship;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttleFake;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.helper.ShuttleTeleportHelper;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import de.katzenpapst.amunra.vec.Vector3int;
import de.katzenpapst.amunra.world.ShuttleDockHandler;
import de.katzenpapst.amunra.world.WorldHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.FluidTank;

public class EntityShuttle
extends EntityTieredRocket {
    protected boolean doKnowOnWhatImStanding = false;
    protected boolean isOnBareGround = false;
    protected int numTanks = 0;
    protected Entity prevRiddenByEntity = null;
    protected Vector3int dockPosition = null;

    public EntityShuttle(World par1World) {
        super(par1World);
        this.func_70105_a(1.2f, 5.5f);
        this.field_70129_M = 1.5f;
    }

    public EntityShuttle(World world, double posX, double posY, double posZ, int type) {
        super(world, posX, posY, posZ);
        this.func_70105_a(1.2f, 3.5f);
        this.field_70129_M = 1.5f;
        this.decodeItemDamage(type);
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.fuelTank = new FluidTank(EntityShuttle.getFuelCapacityFromDamage(type));
    }

    public void setTargetDock(Vector3int dockPos) {
        this.targetVec = dockPos.toBlockVec3();
    }

    protected void decodeItemDamage(int dmg) {
        this.rocketType = EntityShuttle.getRocketTypeFromDamage(dmg);
        this.numTanks = EntityShuttle.getNumTanksFromDamage(dmg);
    }

    protected int encodeItemDamage() {
        return EntityShuttle.encodeItemDamage(this.rocketType.ordinal(), this.numTanks);
    }

    public void setLanding() {
        this.landing = true;
        this.launchPhase = EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal();
    }

    public static int encodeItemDamage(int numChests, int numTanks) {
        return numChests | numTanks << 2;
    }

    public static int getFuelCapacityFromDamage(int damage) {
        int numTanks = EntityShuttle.getNumTanksFromDamage(damage);
        return (1000 + 500 * numTanks) * ConfigManagerCore.rocketFuelFactor;
    }

    public static IRocketType.EnumRocketType getRocketTypeFromDamage(int damage) {
        return IRocketType.EnumRocketType.values()[EntityShuttle.getNumChestsFromDamage(damage)];
    }

    public static boolean isPreFueled(int damage) {
        return damage == 15;
    }

    public static int getNumChestsFromDamage(int damage) {
        return damage & 3;
    }

    public static int getNumTanksFromDamage(int damage) {
        return damage >> 2 & 3;
    }

    public void decodePacketdata(ByteBuf buffer) {
        this.numTanks = buffer.readInt();
        super.decodePacketdata(buffer);
    }

    public void getNetworkedData(ArrayList<Object> list) {
        list.add(this.numTanks);
        super.getNetworkedData(list);
    }

    public EntityShuttle(World par1World, double par2, double par4, double par6, boolean reversed, int rocketType, ItemStack[] inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.cargoItems = inv;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 2;
        }
        return this.rocketType.getInventorySpace();
    }

    public void setCargoContents(ItemStack[] newCargo) {
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        int curIndex = 0;
        for (ItemStack element : newCargo) {
            if (element == null) continue;
            this.cargoItems[curIndex] = element.func_77946_l();
            ++curIndex;
        }
        this.func_70296_d();
    }

    public ItemStack getItemRepresentation() {
        ItemStack rocket = new ItemStack((Item)ARItems.shuttleItem, 1, this.encodeItemDamage());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        return rocket;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack((Item)ARItems.shuttleItem, 1, this.encodeItemDamage());
    }

    public int getRocketTier() {
        return 0;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public int getFuelTankCapacity() {
        return 1000 + 500 * this.numTanks;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public double getOnPadYOffset() {
        return 1.6;
    }

    public double getOnGroundYOffset() {
        return 1.0;
    }

    public double getDistanceFromGround() {
        return 2.8;
    }

    public double func_70042_X() {
        return 0.0;
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched) {
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{this.field_70153_n});
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 + 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 + 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 - 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 - 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.8, y1 - 0.3, z1), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.8, y1 - 0.3, z1), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.8), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.8), new Object[]{this.field_70153_n});
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.2957795);
            if (this.landing && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.y;
                modifier = Math.max(modifier, 1.0);
                x1 *= modifier / 60.0;
                y1 *= modifier / 60.0;
                z1 *= modifier / 60.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1;
            double x2 = this.field_70165_t + x1;
            double z2 = this.field_70161_v + z1;
            Vector3 motionVec = new Vector3(x1, y1, z1);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched());
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched());
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched());
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched());
        }
    }

    protected void failRocket() {
        if (this.shouldCancelExplosion() && this.landing && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.launchPhase = EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal();
            this.landing = false;
            return;
        }
        super.failRocket();
    }

    protected void repositionMountedPlayer(Entity entity) {
        IFuelDock iFuelDock;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.getLandingPad() != null && (iFuelDock = this.getLandingPad()) instanceof TileEntityShuttleDock) {
            TileEntityShuttleDock tileDock = (TileEntityShuttleDock)iFuelDock;
            player.field_70177_z = tileDock.getExitRotation();
            player.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }

    protected void repositionDismountedPlayer(Entity entity) {
        IFuelDock iFuelDock;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.getLandingPad() != null && (iFuelDock = this.getLandingPad()) instanceof TileEntityShuttleDock) {
            TileEntityShuttleDock tileDock = (TileEntityShuttleDock)iFuelDock;
            Vector3 pos = tileDock.getExitPosition();
            player.field_70177_z = tileDock.getExitRotation();
            player.func_70634_a(pos.x, pos.y, pos.z);
        } else {
            int zPos;
            int xPos = (int)(this.field_70165_t - 0.5);
            int yPos = (int)(this.field_70163_u - this.func_70033_W());
            if (this.isSafeForPlayer(xPos, yPos, (zPos = (int)(this.field_70161_v - 0.5)) - 2)) {
                player.func_70634_a(this.field_70165_t, (double)yPos, this.field_70161_v - 2.0);
            } else if (this.isSafeForPlayer(xPos, yPos, zPos + 2)) {
                player.func_70634_a(this.field_70165_t, (double)yPos, this.field_70161_v + 2.0);
            } else if (this.isSafeForPlayer(xPos - 2, yPos, zPos)) {
                player.func_70634_a(this.field_70165_t - 2.0, (double)yPos, this.field_70161_v);
            } else if (this.isSafeForPlayer(xPos + 2, yPos, zPos)) {
                player.func_70634_a(this.field_70165_t + 2.0, (double)yPos, this.field_70161_v);
            }
        }
    }

    protected boolean isSafeForPlayer(double x, double y, double z) {
        int y1 = (int)y;
        return WorldHelper.isNonSolid(this.field_70170_p, (int)x, y1, (int)z) && WorldHelper.isNonSolid(this.field_70170_p, (int)x, y1 + 1, (int)z) && WorldHelper.isSolid(this.field_70170_p, (int)x, y1 - 1, (int)z, true);
    }

    protected void tryFindAnotherDock() {
        Vector3int dock = ShuttleDockHandler.findAvailableDock(this.field_70170_p.field_73011_w.field_76574_g);
        if (dock != null) {
            double yBak = this.field_70163_u;
            this.func_70107_b(dock.x, yBak, dock.z);
            this.targetVec = dock.toBlockVec3();
        } else {
            this.targetVec = null;
        }
    }

    protected void tryToDock() {
        int chunkx = CoordHelper.blockToChunk(this.targetVec.x);
        int chunkz = CoordHelper.blockToChunk(this.targetVec.z);
        if (this.field_70170_p.func_72863_F().func_73149_a(chunkx, chunkz)) {
            TileEntity te = this.targetVec.getTileEntity((IBlockAccess)this.field_70170_p);
            if (te instanceof IFuelDock) {
                if (!(te instanceof TileEntityShuttleDock)) {
                    return;
                }
                TileEntityShuttleDock tileDock = (TileEntityShuttleDock)te;
                if (tileDock.isAvailable()) {
                    tileDock.dockEntity((IDockable)this);
                } else {
                    this.tryFindAnotherDock();
                }
            } else {
                this.tryFindAnotherDock();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.prevRiddenByEntity != this.field_70153_n) {
                if (this.field_70153_n == null && this.prevRiddenByEntity != null) {
                    this.repositionDismountedPlayer(this.prevRiddenByEntity);
                } else if (this.prevRiddenByEntity == null && this.field_70153_n != null) {
                    this.repositionMountedPlayer(this.field_70153_n);
                }
                this.prevRiddenByEntity = this.field_70153_n;
            }
            if (this.landing && this.targetVec != null) {
                this.tryToDock();
            }
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.getLaunched()) {
            if (this.field_70153_n == null) {
                this.landing = true;
            }
            if (this.hasValidFuel()) {
                IGalacticraftWorldProvider gcProvider;
                if (!this.landing) {
                    double d = this.timeSinceLaunch / 150.0f;
                    if ((d = Math.min(d, 1.0)) != 0.0) {
                        this.field_70181_x = -d * 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
                    }
                } else {
                    this.field_70181_x -= 0.008;
                }
                double multiplier = 1.0;
                WorldProvider worldProvider = this.field_70170_p.field_73011_w;
                if (worldProvider instanceof IGalacticraftWorldProvider && (multiplier = (gcProvider = (IGalacticraftWorldProvider)worldProvider).getFuelUsageMultiplier()) <= 0.0) {
                    multiplier = 1.0;
                }
                if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                    this.removeFuel(1);
                    if (!this.hasValidFuel()) {
                        this.stopRocketSound();
                    }
                }
            } else {
                this.landing = true;
                if (!this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
                    this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal()) {
            this.checkStandingPosition();
        }
    }

    public void stopRocketSound() {
        super.stopRocketSound();
        this.rocketSoundUpdater = null;
    }

    protected void checkStandingPosition() {
        if (this.field_70170_p.field_72995_K || this.doKnowOnWhatImStanding && this.field_70173_aa % 40 != 0) {
            return;
        }
        if (this.getLandingPad() != null) {
            this.doKnowOnWhatImStanding = true;
        } else {
            int bZ;
            int bY;
            int bX;
            Vector3int highest;
            TileEntity tile;
            if (this.dockPosition != null && (tile = this.field_70170_p.func_147438_o(this.dockPosition.x, this.dockPosition.y, this.dockPosition.z)) != null) {
                if (tile instanceof IFuelDock) {
                    this.setPad((IFuelDock)tile);
                    this.landEntity(tile);
                    this.dockPosition = null;
                    return;
                }
                this.dockPosition = null;
            }
            boolean isInZeroG = false;
            if (this.field_70170_p.field_73011_w instanceof IZeroGDimension) {
                isInZeroG = true;
            }
            if ((highest = WorldHelper.getHighestNonEmptyBlock(this.field_70170_p, (bX = (int)(this.field_70165_t - 0.5)) - 1, bX + 1, (bY = (int)(this.field_70163_u - 0.5 - 1.0)) - 5, bY, (bZ = (int)(this.field_70161_v - 0.5)) - 1, bZ + 1)) != null) {
                TileEntity tileBelow = this.field_70170_p.func_147438_o(highest.x, highest.y, highest.z);
                IFuelDock dockTile = null;
                if (tileBelow != null) {
                    if (tileBelow instanceof TileEntityMulti) {
                        tileBelow = ((TileEntityMulti)tileBelow).getMainBlockTile();
                    }
                    if (tileBelow instanceof IFuelDock) {
                        dockTile = (IFuelDock)tileBelow;
                    }
                }
                if (dockTile != null) {
                    this.isOnBareGround = false;
                    this.doKnowOnWhatImStanding = true;
                    if (this.getLandingPad() != dockTile) {
                        this.landEntity((TileEntity)dockTile);
                    }
                } else {
                    this.isOnBareGround = true;
                    this.doKnowOnWhatImStanding = true;
                    if (!isInZeroG) {
                        this.adjustGroundPosition(highest.y);
                    }
                }
            } else if (!isInZeroG) {
                this.setLanding();
            }
        }
    }

    public void landEntity(int x, int y, int z) {
        TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
        this.landEntity(tile);
    }

    public void landEntity(TileEntity tile) {
        IFuelDock dock;
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            if (!this.field_70170_p.field_72995_K) {
                IDockable iDockable = dock.getDockedEntity();
                if (iDockable instanceof EntitySpaceshipBase) {
                    EntitySpaceshipBase entitySpaceship = (EntitySpaceshipBase)iDockable;
                    if (dock.getDockedEntity() != this) {
                        entitySpaceship.dropShipAsItem();
                        entitySpaceship.func_70106_y();
                    }
                }
                this.setPad(dock);
            }
            this.onRocketLand(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }

    public void setPad(IFuelDock pad) {
        this.isOnBareGround = false;
        this.doKnowOnWhatImStanding = true;
        super.setPad(pad);
    }

    protected void adjustGroundPosition(int blockYPos) {
        this.func_70107_b(this.field_70165_t, this.getDistanceFromGround() + (double)blockYPos, this.field_70161_v);
    }

    public void onReachAtmosphere() {
        Entity entity;
        if (this.field_70153_n != null && !this.field_70170_p.field_72995_K && (entity = this.field_70153_n) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            this.onTeleport(player);
            GCPlayerStats stats = this.setGCPlayerStats(player);
            EntityShuttle.toCelestialSelection(player, stats, this.getRocketTier());
        }
        this.func_70106_y();
    }

    public GCPlayerStats setGCPlayerStats(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
        stats.rocketStacks = this.cargoItems == null || this.cargoItems.length == 0 ? new ItemStack[2] : this.cargoItems;
        stats.rocketType = this.encodeItemDamage();
        stats.rocketItem = ARItems.shuttleItem;
        stats.fuelLevel = this.fuelTank.getFluidAmount();
        return stats;
    }

    public static void toCelestialSelection(EntityPlayerMP player, GCPlayerStats stats, int tier) {
        EntityShuttle.toCelestialSelection(player, stats, tier, true);
    }

    public static void toCelestialSelection(EntityPlayerMP player, GCPlayerStats stats, int tier, boolean useFakeEntity) {
        player.func_70078_a(null);
        stats.spaceshipTier = tier;
        HashMap<String, Integer> map = ShuttleTeleportHelper.getArrayOfPossibleDimensions(player);
        String dimensionList = "";
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            dimensionList = dimensionList.concat((String)entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        AmunRa.packetPipeline.sendTo(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_OPEN_SHUTTLE_GUI, player.func_146103_bH().getName(), dimensionList), player);
        stats.usingPlanetSelectionGui = false;
        stats.savedPlanetList = new String(dimensionList);
        if (useFakeEntity) {
            EntityShuttleFake fakeEntity = new EntityShuttleFake(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f);
            player.field_70170_p.func_72838_d((Entity)fakeEntity);
            player.func_70078_a((Entity)fakeEntity);
        }
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = this.getItemRepresentation();
        droppedItems.add(rocket);
        return droppedItems;
    }

    public List<ItemStack> getCargoContents() {
        ArrayList<ItemStack> droppedItemList = new ArrayList<ItemStack>();
        if (this.cargoItems != null) {
            for (ItemStack item : this.cargoItems) {
                if (item == null) continue;
                droppedItemList.add(item);
            }
        }
        return droppedItemList;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("NumTanks", this.numTanks);
        if (this.getLandingPad() != null) {
            Vector3int pos = new Vector3int((TileEntity)this.getLandingPad());
            nbt.func_74782_a("dockPosition", (NBTBase)pos.toNBT());
        }
        super.func_70014_b(nbt);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagCompound dockPosNbt;
        this.numTanks = nbt.func_74762_e("NumTanks");
        if (nbt.func_74764_b("dockPosition") && (dockPosNbt = nbt.func_74775_l("dockPosition")) != null) {
            this.dockPosition = new Vector3int(dockPosNbt);
        }
        super.func_70037_a(nbt);
    }
}

