/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.IMetaBlock;
import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.block.SubBlockMachine;
import de.katzenpapst.amunra.item.ItemBlockMulti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachineMeta
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc,
IMetaBlock {
    protected SubBlockMachine[] subBlocksArray;
    protected final Map<String, Integer> nameMetaMap = new HashMap<String, Integer>();
    protected String blockNameFU;

    public BlockMachineMeta(String name, Material material) {
        super(material);
        this.blockNameFU = name;
        this.subBlocksArray = new SubBlockMachine[4];
        this.func_149663_c(this.blockNameFU);
    }

    protected BlockMachineMeta(String name, Material material, int numSubBlocks) {
        super(material);
        this.blockNameFU = name;
        this.subBlocksArray = new SubBlockMachine[numSubBlocks];
        this.func_149663_c(this.blockNameFU);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        SubBlock leBlock = this.getSubBlock(meta);
        if (leBlock == null) {
            return null;
        }
        return leBlock.func_149691_a(side, meta);
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random random) {
        SubBlock sb;
        if (!worldIn.field_72995_K && (sb = this.getSubBlock(worldIn.func_72805_g(x, y, z))) != null) {
            sb.func_149674_a(worldIn, x, y, z, random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (SubBlockMachine sb : this.subBlocksArray) {
            if (sb == null) continue;
            sb.func_149651_a(reg);
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149712_f(worldIn, x, y, z);
        }
        return super.func_149712_f(worldIn, x, y, z);
    }

    public String getShiftDescription(int meta) {
        SubBlock subBlock = this.getSubBlock(meta);
        if (subBlock instanceof SubBlockMachine) {
            SubBlockMachine sbm = (SubBlockMachine)subBlock;
            return sbm.getShiftDescription(0);
        }
        return "";
    }

    public boolean showDescription(int meta) {
        SubBlock subBlock = this.getSubBlock(meta);
        if (subBlock instanceof SubBlockMachine) {
            SubBlockMachine sbm = (SubBlockMachine)subBlock;
            return sbm.showDescription(0);
        }
        return false;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        SubBlock subBlock = this.getSubBlock(world.func_72805_g(x, y, z));
        if (subBlock instanceof SubBlockMachine) {
            SubBlockMachine sbm = (SubBlockMachine)subBlock;
            return sbm.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        return super.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    @Override
    public BlockMetaPair addSubBlock(int meta, SubBlock sb) {
        if (!(sb instanceof SubBlockMachine)) {
            throw new IllegalArgumentException("BlockMachineMeta can only accept SubBlockMachine");
        }
        SubBlockMachine sbm = (SubBlockMachine)sb;
        if (meta >= this.subBlocksArray.length || meta < 0) {
            throw new IllegalArgumentException("Meta " + meta + " must be < " + this.subBlocksArray.length + " and >= 0");
        }
        if (this.subBlocksArray[meta] != null) {
            throw new IllegalArgumentException("Meta " + meta + " is already in use in " + this.blockNameFU);
        }
        if (this.nameMetaMap.containsKey(sb.func_149739_a())) {
            throw new IllegalArgumentException("Name " + sb.func_149739_a() + " is already in use in " + this.blockNameFU);
        }
        sb.setParent(this);
        this.nameMetaMap.put(sb.func_149739_a(), meta);
        this.subBlocksArray[meta] = sbm;
        return new BlockMetaPair((Block)this, (byte)meta);
    }

    @Override
    public int getMetaByName(String name) {
        if (this.nameMetaMap.containsKey(name)) {
            return this.nameMetaMap.get(name);
        }
        throw new IllegalArgumentException("Subblock " + name + " doesn't exist in " + this.blockNameFU);
    }

    @Override
    public SubBlock getSubBlock(int meta) {
        return this.subBlocksArray[this.getDistinctionMeta(meta)];
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return AmunRa.arTab;
    }

    @Override
    public String getUnlocalizedSubBlockName(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.func_149739_a();
        }
        return this.func_149739_a();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.getSubBlock(meta) != null) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.getDistinctionMeta(meta));
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    @Override
    public void register() {
        GameRegistry.registerBlock((Block)this, ItemBlockMulti.class, (String)this.func_149739_a());
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            SubBlockMachine sb = this.subBlocksArray[i];
            if (sb == null) continue;
            this.setHarvestLevel(sb.getHarvestTool(0), sb.getHarvestLevel(0), i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            if (this.subBlocksArray[i] == null) continue;
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.createTileEntity(world, metadata);
        }
        return super.createTileEntity(world, metadata);
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int n;
        int metadata = world.func_72805_g(x, y, z);
        SubBlock sb = this.getSubBlock(metadata);
        if (sb == null || !sb.canBeMoved(world, x, y, z)) {
            return false;
        }
        int original = this.getRotationMeta(metadata);
        switch (original) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        int change = n;
        change = this.addRotationMeta(this.getDistinctionMeta(metadata), change);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileBaseUniversalElectrical) {
            TileBaseUniversalElectrical tileUE = (TileBaseUniversalElectrical)te;
            tileUE.updateFacing();
        }
        world.func_72921_c(x, y, z, change, 3);
        return true;
    }

    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        SubBlock sb;
        int n;
        int metadata = worldIn.func_72805_g(x, y, z);
        int dist = this.getDistinctionMeta(metadata);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (angle) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        int change = n;
        change = this.addRotationMeta(dist, change);
        worldIn.func_72921_c(x, y, z, change, 3);
        TileEntity tile = worldIn.func_147438_o(x, y, z);
        if (tile instanceof TileBaseUniversalElectrical) {
            TileBaseUniversalElectrical tileUE = (TileBaseUniversalElectrical)tile;
            tileUE.updateFacing();
        }
        if ((sb = this.getSubBlock(dist)) != null) {
            sb.func_149689_a(worldIn, x, y, z, placer, itemIn);
        }
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return Item.func_150898_a((Block)this);
        }
        return sb.func_149650_a(0, random, fortune);
    }

    public int func_149692_a(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return this.getDistinctionMeta(meta);
        }
        return sb.func_149692_a(0);
    }

    public int func_149643_k(World worldIn, int x, int y, int z) {
        return this.getDistinctionMeta(worldIn.func_72805_g(x, y, z));
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb == null || sb.dropsSelf()) {
            return 1;
        }
        return sb.quantityDropped(meta, fortune, random);
    }

    public boolean func_149655_b(IBlockAccess worldIn, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.func_149655_b(worldIn, x, y, z);
        }
        return super.func_149655_b(worldIn, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        SubBlock subBlock;
        int meta = world.func_72805_g(x, y, z);
        if (this.isUsableWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z)) {
            this.damageWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z);
            if (entityPlayer.func_70093_af() && this.onSneakUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ) || this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
        }
        if ((subBlock = this.getSubBlock(meta)) instanceof SubBlockMachine) {
            SubBlockMachine sb = (SubBlockMachine)subBlock;
            if (entityPlayer.func_70093_af() && sb.onSneakMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
            return sb.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.hasTileEntity(metadata);
        }
        return super.hasTileEntity(metadata);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            sb.func_149749_a(world, x, y, z, block, metadata);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        SubBlock sb = this.getSubBlock(metadata);
        if (sb != null) {
            return sb.getExpDrop(world, 0, fortune);
        }
        return super.getExpDrop(world, metadata, fortune);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            sb.func_149695_a(worldIn, x, y, z, neighbor);
        }
        super.func_149695_a(worldIn, x, y, z, neighbor);
    }

    public int func_149660_a(World worldIn, int x, int y, int z, int side, float subX, float subY, float subZ, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb != null) {
            return sb.func_149660_a(worldIn, x, y, z, side, subX, subY, subZ, meta);
        }
        return super.func_149660_a(worldIn, x, y, z, side, subX, subY, subZ, meta);
    }

    @Override
    public int getNumPossibleSubBlocks() {
        return this.subBlocksArray.length;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        SubBlock sb = this.getSubBlock(world.func_72805_g(x, y, z));
        if (sb != null) {
            return sb.removedByPlayer(world, player, x, y, z);
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public boolean func_149705_a(World worldIn, int x, int y, int z, int side, ItemStack itemIn) {
        SubBlock sb;
        if (itemIn != null && (sb = this.getSubBlock(itemIn.func_77960_j())) != null) {
            return sb.func_149705_a(worldIn, x, y, z, side, itemIn);
        }
        return super.func_149705_a(worldIn, x, y, z, side, itemIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World worldIn, int x, int y, int z, Random random) {
        SubBlock sb = this.getSubBlock(worldIn.func_72805_g(x, y, z));
        if (sb != null) {
            sb.func_149734_b(worldIn, x, y, z, random);
        }
    }
}

