/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.quad.writers;

import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.writers.IWriteQuads;
import java.nio.ByteBuffer;

public class PositionTextureQuadWriter
implements IWriteQuads {
    private boolean direct;

    public PositionTextureQuadWriter() {
        this.init(false);
    }

    public void init(boolean direct) {
        this.direct = direct;
    }

    @Override
    public void writeQuad(QuadView quad, ByteBuffer buf) {
        if (this.direct) {
            this.writeQuadDirect(quad, buf);
        } else {
            this.writeQuadIndirect(quad, buf);
        }
    }

    protected void writeQuadDirect(QuadView quad, ByteBuffer buf) {
        throw new UnsupportedOperationException("Direct mode not supported yet");
    }

    protected void writeQuadIndirect(QuadView quad, ByteBuffer buf) {
        for (int idx = 0; idx < 4; ++idx) {
            buf.putFloat(quad.getX(idx));
            buf.putFloat(quad.getY(idx));
            buf.putFloat(quad.getZ(idx));
            buf.putFloat(quad.getTexU(idx));
            buf.putFloat(quad.getTexV(idx));
        }
    }
}

