/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.blocks.ISubBlocksBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseSubtypesBlock
extends BaseBlock
implements ISubBlocksBlock {
    private IIcon[] icons;
    private final String[] types;
    private final int startMeta;
    private final Map<Integer, Float> hardnesses = Maps.newHashMap();
    private final Map<Integer, Float> resistances = Maps.newHashMap();

    public BaseSubtypesBlock(Material material, String ... types) {
        this(material, 0, types);
    }

    public BaseSubtypesBlock(Material material, int startMeta, String ... types) {
        super(material);
        this.startMeta = startMeta;
        this.types = types;
        if (!"".equals(types[0])) {
            this.setNames(types[0]);
        }
    }

    @Override
    public IIcon[] getIcons() {
        return this.icons;
    }

    protected void setIcons(IIcon[] icons) {
        this.icons = icons;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public String getNameFor(ItemStack stack) {
        String type = this.getTypes()[Math.max(this.startMeta, stack.func_77960_j() % this.getTypes().length)];
        return "".equals(type) ? this.func_149739_a().replace("tile.", "").replace("etfuturum.", "") : type;
    }

    public int func_149692_a(int meta) {
        return meta % this.getTypes().length;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = this.startMeta; i < this.getTypes().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIcons()[Math.max(this.startMeta, meta % this.icons.length)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.setIcons(new IIcon[this.getTypes().length]);
        for (int i = 0; i < this.getIcons().length; ++i) {
            this.getIcons()[i] = "".equals(this.getTypes()[i]) ? reg.func_94245_a(this.func_149641_N()) : reg.func_94245_a((this.getTextureDomain().isEmpty() ? "" : this.getTextureDomain() + ":") + (this.getTextureSubfolder().isEmpty() ? "" : this.getTextureSubfolder() + "/") + this.getTypes()[i]);
        }
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        return this.hardnesses.getOrDefault(worldIn.func_72805_g(x, y, z), Float.valueOf(super.func_149712_f(worldIn, x, y, z))).floatValue();
    }

    public BaseSubtypesBlock setHardnessValues(float hardness, int ... metas) {
        if (metas.length == 0) {
            this.func_149711_c(hardness);
        } else {
            for (int meta : metas) {
                this.hardnesses.put(meta, Float.valueOf(hardness));
            }
        }
        return this;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Float resistance = this.resistances.get(world.func_72805_g(x, y, z));
        if (resistance != null) {
            return resistance.floatValue() / 5.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public BaseSubtypesBlock setResistanceValues(float resistance, int ... metas) {
        if (metas.length == 0) {
            this.func_149752_b(resistance);
        } else {
            for (int meta : metas) {
                this.resistances.put(meta, Float.valueOf(resistance));
            }
        }
        return this;
    }
}

