/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedSlab;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PaintedBlockAccessWrapper;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.TileEntityPaintedSlab;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPaintedSlab
extends BlockSlab
implements ITileEntityProvider,
IPaintedBlock {
    private IIcon lastRemovedComponetIcon = null;
    private Random rand = new Random();
    private final boolean isDouble;

    public BlockPaintedSlab(boolean isDouble) {
        super(isDouble, Material.field_151576_e);
        this.isDouble = isDouble;
        this.func_149647_a(null);
        this.func_149663_c(ModObject.blockPaintedSlab.unlocalisedName + (isDouble ? "Double" : ""));
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        if (!isDouble) {
            this.field_149783_u = true;
        }
    }

    public void init() {
        if (this.isDouble) {
            GameRegistry.registerBlock((Block)this, BlockItemPaintedSlab.class, (String)ModObject.blockPaintedDoubleSlab.unlocalisedName);
            GameRegistry.registerTileEntity(TileEntityPaintedSlab.class, (String)(ModObject.blockPaintedDoubleSlab.unlocalisedName + "TileEntity"));
        } else {
            GameRegistry.registerBlock((Block)this, BlockItemPaintedSlab.class, (String)ModObject.blockPaintedSlab.unlocalisedName);
            GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedSlab.unlocalisedName + "TileEntity"));
            MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
        }
    }

    public static ItemStack createItemStackForSourceBlock(Block source, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedSlab, 1, 0);
        PainterUtil.setSourceBlock(result, source, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149691_a(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.field_150467_bQ.func_149673_e(world, x, y, z, blockSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:conduitConnector");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.func_149691_a(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.field_149761_L;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.field_72311_b, target.field_72312_c, target.field_72309_d, target.field_72310_e, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).func_70596_a(x, y, z);
                    fx.func_110125_a(tex);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)y + this.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)z + this.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        if (side == 0) {
            d1 = (double)y + this.func_149665_z() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.func_149669_A() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.func_149706_B() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.func_149693_C() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.func_149704_x() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.func_149753_y() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_110125_a(tex);
        effectRenderer.func_78873_a((EntityFX)digFX);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedSlab();
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return Math.min(super.getLightOpacity(world, x, y, z), tef.getSourceBlock().getLightOpacity(world, x, y, z));
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            Block b = PainterUtil.getSourceBlock(stack);
            tef.setSourceBlock(b);
            tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        }
        world.func_147471_g(x, y, z);
        super.func_149689_a(world, x, y, z, player, stack);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean doHarvest) {
        TileEntity te;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (te = world.func_147438_o(x, y, z)) instanceof TileEntityPaintedSlab && !((TileEntityPaintedSlab)te).isConvertingToFullBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            for (int i = 0; i < super.func_149745_a(null); ++i) {
                ItemStack itemStack = BlockPaintedSlab.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
                this.func_149642_a(world, x, y, z, itemStack);
            }
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public String func_150002_b(int var1) {
        return this.func_149739_a();
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            PaintedBlockAccessWrapper ba = new PaintedBlockAccessWrapper(world);
            return tef.getSourceBlock().func_149720_d((IBlockAccess)ba, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{Blocks.field_150376_bx, Blocks.field_150333_U, EnderIO.blockPaintedDoubleSlab, BlockPaintedSlab.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedSlab.createItemStackForSourceBlock(Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }

        @Override
        public boolean isValidTarget(ItemStack target) {
            if (target == null) {
                return false;
            }
            Block blk = Block.func_149634_a((Item)target.func_77973_b());
            return blk instanceof BlockSlab;
        }
    }
}

