/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class LevelGeneratorClassic
implements ILevelGenerator {
    private IWorldEditor editor;
    private Random rand;
    private IDungeonLevel level;
    private List<DungeonNode> nodes;
    private List<DungeonTunnel> tunnels;
    private DungeonNode end;

    public LevelGeneratorClassic(IWorldEditor editor, Random rand, IDungeonLevel level) {
        this.editor = editor;
        this.rand = rand;
        this.level = level;
        this.nodes = new ArrayList<DungeonNode>();
        this.tunnels = new ArrayList<DungeonTunnel>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(Coord start, DungeonNode oldEnd) {
        void var6_9;
        ArrayList<Node> gNodes = new ArrayList<Node>();
        Node startNode = new Node(this, this.level.getSettings(), Cardinal.directions[this.rand.nextInt(Cardinal.directions.length)], start);
        gNodes.add(startNode);
        while (!this.isDone(gNodes)) {
            this.update(gNodes);
        }
        for (Node node : gNodes) {
            node.cull();
        }
        DungeonNode startDungeonNode = null;
        for (Node node : gNodes) {
            DungeonNode nToAdd = node.createNode();
            if (node == startNode) {
                startDungeonNode = nToAdd;
            }
            this.nodes.add(nToAdd);
            this.tunnels.addAll(node.createTunnels(this.editor));
        }
        boolean bl = false;
        do {
            this.end = this.nodes.get(this.rand.nextInt(this.nodes.size()));
        } while (this.end == startDungeonNode || this.end.getPosition().distance(start) > (double)(16 + ++var6_9 * 2));
        for (DungeonTunnel t : this.getTunnels()) {
            t.construct(this.editor, this.rand, this.level.getSettings());
        }
        List<DungeonNode> list = this.getNodes();
        Collections.shuffle(list, this.rand);
        for (DungeonNode node : list) {
            if (node == this.end || node == startDungeonNode) continue;
            IDungeonRoom toGenerate = this.level.getSettings().getRooms().get(this.rand);
            node.setDungeon(toGenerate);
            toGenerate.generate(this.editor, this.rand, this.level.getSettings(), node.getEntrances(), node.getPosition());
        }
        for (DungeonTunnel tunnel : this.getTunnels()) {
            tunnel.genSegments(this.editor, this.rand, this.level);
        }
        LevelGenerator.generateLevelLink(this.editor, this.rand, this.level.getSettings(), start, oldEnd);
    }

    public void update(List<Node> nodes) {
        if (!this.full(nodes)) {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).update(nodes);
            }
        }
    }

    private boolean isDone(List<Node> nodes) {
        boolean allDone = true;
        for (Node node : nodes) {
            if (node.isDone()) continue;
            allDone = false;
        }
        return allDone || this.full(nodes);
    }

    private boolean full(List<Node> nodes) {
        return nodes.size() >= this.level.getSettings().getNumRooms();
    }

    public void spawnNode(List<Node> nodes, Tunneler tunneler) {
        Node toAdd = new Node(this, this.level.getSettings(), tunneler.getDirection(), tunneler.getPosition());
        nodes.add(toAdd);
    }

    public boolean hasNearbyNode(List<Node> nodes, Coord pos, int min) {
        for (Node node : nodes) {
            int dist = (int)node.getPos().distance(pos);
            if (dist >= min) continue;
            return true;
        }
        return false;
    }

    public IDungeonLevel getLevel() {
        return this.level;
    }

    @Override
    public List<DungeonNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<DungeonTunnel> getTunnels() {
        return this.tunnels;
    }

    @Override
    public DungeonNode getEnd() {
        return this.end;
    }

    private class Node {
        private List<Tunneler> tunnelers = new ArrayList<Tunneler>();
        private LevelGeneratorClassic level;
        private LevelSettings settings;
        private Cardinal direction;
        private Coord pos;

        public Node(LevelGeneratorClassic level, LevelSettings settings, Cardinal direction, Coord pos) {
            this.level = level;
            this.settings = settings;
            this.direction = direction;
            this.pos = pos;
            this.spawnTunnelers();
        }

        private void spawnTunnelers() {
            if (!this.level.level.inRange(this.pos)) {
                return;
            }
            for (Cardinal dir : Cardinal.directions) {
                if (dir.equals((Object)Cardinal.reverse(this.direction))) continue;
                this.tunnelers.add(new Tunneler(dir, this.settings, this.level, new Coord(this.pos)));
            }
        }

        public void update(List<Node> nodes) {
            for (Tunneler tunneler : this.tunnelers) {
                tunneler.update(nodes);
            }
        }

        public boolean isDone() {
            for (Tunneler tunneler : this.tunnelers) {
                if (tunneler.isDone()) continue;
                return false;
            }
            return true;
        }

        public Coord getPos() {
            return new Coord(this.pos);
        }

        public Cardinal[] getEntrances() {
            ArrayList<Cardinal> c = new ArrayList<Cardinal>();
            c.add(Cardinal.reverse(this.direction));
            for (Tunneler t : this.tunnelers) {
                c.add(t.dir);
            }
            return c.toArray(new Cardinal[c.size()]);
        }

        public List<DungeonTunnel> createTunnels(IWorldEditor editor) {
            ArrayList<DungeonTunnel> tunnels = new ArrayList<DungeonTunnel>();
            for (Tunneler t : this.tunnelers) {
                tunnels.add(t.createTunnel());
            }
            return tunnels;
        }

        public DungeonNode createNode() {
            return new DungeonNode(this.getEntrances(), this.pos);
        }

        public void cull() {
            ArrayList<Tunneler> toKeep = new ArrayList<Tunneler>();
            for (Tunneler t : this.tunnelers) {
                if (!t.done) continue;
                toKeep.add(t);
            }
            this.tunnelers = toKeep;
        }
    }

    private class Tunneler {
        private boolean done = false;
        private Cardinal dir;
        private LevelSettings settings;
        private LevelGeneratorClassic generator;
        private Coord start;
        private Coord end;
        private int extend;

        public Tunneler(Cardinal dir, LevelSettings settings, LevelGeneratorClassic generator, Coord start) {
            this.dir = dir;
            this.settings = settings;
            this.generator = generator;
            this.start = new Coord(start);
            this.end = new Coord(start);
            this.extend = settings.getScatter() * 2;
        }

        public void update(List<Node> nodes) {
            if (this.done) {
                return;
            }
            if (this.generator.hasNearbyNode(nodes, this.end, this.settings.getScatter())) {
                this.end.add(this.dir);
            } else if (LevelGeneratorClassic.this.rand.nextInt(this.extend) == 0) {
                this.generator.spawnNode(nodes, this);
                this.done = true;
            } else {
                this.end.add(this.dir);
                --this.extend;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public Cardinal getDirection() {
            return this.dir;
        }

        public Coord getPosition() {
            return new Coord(this.end);
        }

        public DungeonTunnel createTunnel() {
            return new DungeonTunnel(LevelGeneratorClassic.this.editor, new Coord(this.start), new Coord(this.end), this.dir);
        }
    }
}

