/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widget.sizer.Area;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class Stencil {
    private static final ObjectArrayList<Area> stencils = new ObjectArrayList();
    private static final ObjectArrayList<Runnable> stencilShapes = new ObjectArrayList();
    private static int stencilValue = 0;

    public static void reset() {
        stencils.clear();
        stencilShapes.clear();
        stencilValue = 0;
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glStencilFunc((int)519, (int)0, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
    }

    public static void apply(Rectangle area, @Nullable GuiContext context) {
        Stencil.apply(area.x, area.y, area.width, area.height, context);
    }

    public static void applyAtZero(Rectangle area, @Nullable GuiContext context) {
        Stencil.apply(0, 0, area.width, area.height, context);
    }

    public static void applyTransformed(Rectangle area) {
        Stencil.applyTransformed(area.x, area.y, area.width, area.height);
    }

    public static void applyTransformed(int x, int y, int w, int h) {
        Stencil.apply(x, y, w, h, null);
    }

    public static void apply(int x, int y, int w, int h, @Nullable GuiContext context) {
        Stencil.apply(() -> Stencil.drawRectangleStencilShape(x, y, w, h), x, y, w, h, context);
    }

    public static void apply(Runnable stencilShape, boolean hideStencilShape) {
        Stencil.apply(stencilShape, 0, 0, 0, 0, null, hideStencilShape);
    }

    public static void apply(Runnable stencilShape, int x, int y, int w, int h, @Nullable GuiContext context) {
        Stencil.apply(stencilShape, x, y, w, h, context, true);
    }

    public static void apply(Runnable stencilShape, int x, int y, int w, int h, @Nullable GuiContext context, boolean hideStencilShape) {
        Area scissor = new Area(x, y, w, h);
        if (context != null) {
            scissor.transformAndRectanglerize(context);
        }
        if (!stencils.isEmpty()) {
            ((Area)stencils.top()).clamp(scissor);
        }
        Stencil.applyShape(stencilShape, hideStencilShape);
        stencils.add((Object)scissor);
        stencilShapes.add((Object)stencilShape);
    }

    private static void applyShape(Runnable stencilShape, boolean hideStencilShape) {
        GL11.glEnable((int)2960);
        Stencil.setStencilValue(stencilShape, stencilValue, false, hideStencilShape);
        GL11.glStencilFunc((int)515, (int)(++stencilValue), (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
    }

    private static void setStencilValue(Runnable stencilShape, int stencilValue, boolean remove, boolean hideStencilShape) {
        int mode = remove ? 7683 : 7682;
        GL11.glStencilFunc((int)514, (int)stencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)mode, (int)mode);
        GL11.glStencilMask((int)255);
        if (hideStencilShape) {
            GlStateManager.colorMask(false, false, false, false);
            GlStateManager.depthMask(false);
        }
        stencilShape.run();
        if (hideStencilShape) {
            GlStateManager.colorMask(true, true, true, true);
            GlStateManager.depthMask(true);
        }
    }

    private static void drawRectangleStencilShape(int x, int y, int w, int h) {
        Platform.setupDrawColor();
        Platform.startDrawing(Platform.DrawMode.QUADS, Platform.VertexFormat.POS, bufferBuilder -> {
            float x0 = x;
            float x1 = x + w;
            float y0 = y;
            float y1 = y + h;
            bufferBuilder.pos(x0, y0, 0.0).endVertex();
            bufferBuilder.pos(x0, y1, 0.0).endVertex();
            bufferBuilder.pos(x1, y1, 0.0).endVertex();
            bufferBuilder.pos(x1, y0, 0.0).endVertex();
        });
    }

    public static void remove() {
        stencils.pop();
        Runnable stencilShape = (Runnable)stencilShapes.pop();
        if (stencils.isEmpty()) {
            Stencil.reset();
            GL11.glDisable((int)2960);
            return;
        }
        Stencil.setStencilValue(stencilShape, stencilValue, true, true);
        GL11.glStencilFunc((int)515, (int)(--stencilValue), (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
    }

    public static boolean isInsideScissorArea(Area area, IViewportStack stack) {
        if (stencils.isEmpty()) {
            return true;
        }
        Area.SHARED.set(0, 0, area.width, area.height);
        Area.SHARED.transformAndRectanglerize(stack);
        return ((Area)stencils.top()).intersects(Area.SHARED);
    }
}

