/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.StyledText;
import com.cleanroommc.modularui.drawable.text.TextIcon;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class IconRenderer {
    public static final IconRenderer SHARED = new IconRenderer();
    protected float maxWidth = -1.0f;
    protected float maxHeight = -1.0f;
    protected int x = 0;
    protected int y = 0;
    protected Alignment alignment = Alignment.TopLeft;
    protected float scale = 1.0f;
    protected boolean shadow = false;
    protected int color = 0;
    protected int linePadding = 1;
    protected boolean simulate;
    protected float lastWidth = 0.0f;
    protected float lastHeight = 0.0f;
    protected boolean useWholeWidth = false;

    public void setAlignment(Alignment alignment, float maxWidth) {
        this.setAlignment(alignment, maxWidth, -1.0f);
    }

    public void setAlignment(Alignment alignment, float maxWidth, float maxHeight) {
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setLinePadding(int linePadding) {
        this.linePadding = linePadding;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void setUseWholeWidth(boolean useWholeWidth) {
        this.useWholeWidth = useWholeWidth;
    }

    public void draw(GuiContext context, IDrawable text) {
        this.draw(context, Collections.singletonList(text));
    }

    public void draw(GuiContext context, List<IDrawable> lines) {
        this.drawMeasuredLines(context, this.measureLines(lines));
    }

    public void drawMeasuredLines(GuiContext context, List<IIcon> lines) {
        TextRenderer.SHARED.setColor(this.color);
        TextRenderer.SHARED.setShadow(this.shadow);
        TextRenderer.SHARED.setScale(this.scale);
        TextRenderer.SHARED.setAlignment(this.alignment, this.maxWidth);
        int totalHeight = -1;
        int maxWidth = 0;
        if (this.useWholeWidth) {
            maxWidth = (int)this.maxWidth;
        }
        for (IIcon icon : lines) {
            totalHeight += icon.getHeight() + this.linePadding;
            if (this.useWholeWidth || icon.getWidth() <= 0) continue;
            maxWidth = Math.max(maxWidth, icon.getWidth());
        }
        if (!lines.isEmpty()) {
            totalHeight -= this.linePadding;
        }
        int y = this.getStartY(totalHeight);
        for (IIcon icon : lines) {
            int x;
            int n = x = icon.getWidth() > 0 ? this.getStartX(icon.getWidth()) : this.x;
            if (!this.simulate) {
                icon.draw(context, x, y, maxWidth, icon.getHeight(), WidgetTheme.getDefault());
            }
            y += (int)((float)(icon.getHeight() + this.linePadding) * this.scale);
        }
        this.lastWidth = this.maxWidth > 0.0f ? Math.min(this.maxWidth, (float)maxWidth) : (float)maxWidth;
        this.lastHeight = (float)totalHeight * this.scale;
    }

    public List<IIcon> measureLines(List<IDrawable> lines) {
        ArrayList<IIcon> icons = new ArrayList<IIcon>();
        for (IDrawable element : lines) {
            if (element instanceof IIcon) {
                IIcon icon = (IIcon)element;
                icons.add(icon);
                continue;
            }
            if (element instanceof IKey) {
                IKey key = (IKey)element;
                float scale = this.scale;
                Alignment alignment1 = this.alignment;
                if (element instanceof StyledText) {
                    StyledText styledText = (StyledText)element;
                    scale = styledText.getScale();
                    alignment1 = styledText.getAlignment();
                }
                String text = key.get();
                for (String subLine : text.split("\\\\n")) {
                    for (String subSubLine : this.wrapLine(subLine, scale)) {
                        int width = (int)((float)IconRenderer.getFontRenderer().func_78256_a(subSubLine) * scale);
                        icons.add(new TextIcon(subSubLine, width, (int)((float)IconRenderer.getFontRenderer().field_78288_b * scale), scale, alignment1));
                    }
                }
                continue;
            }
            icons.add(element.asIcon().height(IconRenderer.getFontRenderer().field_78288_b));
        }
        return icons;
    }

    public List<String> wrapLine(String line, float scale) {
        return this.maxWidth > 0.0f ? IconRenderer.getFontRenderer().func_78271_c(line, (int)(this.maxWidth / scale)) : Collections.singletonList(line);
    }

    protected int getStartY(int totalHeight) {
        if (this.alignment.y > 0.0f && this.maxHeight > 0.0f) {
            float height = (float)totalHeight * this.scale;
            return (int)((float)this.y + this.maxHeight * this.alignment.y - height * this.alignment.y);
        }
        return this.y;
    }

    protected int getStartX(float lineWidth) {
        if (this.alignment.x > 0.0f && this.maxWidth > 0.0f) {
            return (int)((float)this.x + this.maxWidth * this.alignment.x - lineWidth * this.alignment.x);
        }
        return this.x;
    }

    public float getFontHeight() {
        return (float)IconRenderer.getFontRenderer().field_78288_b * this.scale;
    }

    public float getLastHeight() {
        return this.lastHeight;
    }

    public float getLastWidth() {
        return this.lastWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

