/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.IAutomagyLocationLink;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.renderers.BlockScribePointerRenderer;
import tuhljin.automagy.tiles.IContainsEyes;
import tuhljin.automagy.tiles.InventoryObjectEyes;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityUnseenScribe;

public class TileEntityScribePointer
extends ModTileEntity
implements IContainsEyes {
    public static int RANGE = 10;
    public static int MAX_EYES = 5;
    public InventoryObjectEyes eyesContainingInventory = new InventoryObjectEyes(this, "Scribe Pointer", MAX_EYES, true);
    protected int eyeCount = 0;
    public int currentDisplayIndex = 0;
    public int ticks;
    public int displayChangedTick = -1;
    public ItemStack displayStack;
    public int rangeBoosters = -1;

    public TileEntityScribePointer() {
    }

    public TileEntityScribePointer(World world) {
        this();
        this.ticks = world.field_73012_v.nextInt(500);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.eyeCount > 0 && this.displayStack == null && this.ticks % 8 == 0) {
                float x = (float)this.field_145851_c + 0.5f;
                float y = this.field_145848_d;
                float z = (float)this.field_145849_e + 0.5f;
                switch (this.func_145832_p()) {
                    case 0: {
                        x += 0.35f;
                        z += -0.35f;
                        break;
                    }
                    case 1: {
                        x += 0.35f;
                        z += 0.35f;
                        break;
                    }
                    case 2: {
                        x += -0.35f;
                        z += 0.35f;
                        break;
                    }
                    case 3: {
                        x += -0.35f;
                        z += -0.35f;
                    }
                }
                int color = 5;
                Thaumcraft.proxy.sparkle(x + this.field_145850_b.field_73012_v.nextFloat() * 0.2f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f, y + 0.1f, z + this.field_145850_b.field_73012_v.nextFloat() * 0.2f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 1.0f, color, -0.1f);
            }
        }
    }

    @Override
    public void onEyesInventoryChanged(int slot, ItemStack prevStack) {
    }

    @Override
    public int getDimensionID() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    @Override
    public BlockCoord getPosition() {
        return new BlockCoord(this);
    }

    @Override
    public int getMaxDistance() {
        return RANGE;
    }

    public ItemStack removeEye() {
        if (this.eyeCount > 0) {
            int slot = this.eyeCount - 1;
            ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
            this.eyesContainingInventory.func_70299_a(slot, null);
            --this.eyeCount;
            this.func_70296_d();
            this.rangeBoosters = -1;
            return stack;
        }
        return null;
    }

    public boolean insertEye(ItemStack stack) {
        if (this.eyeCount < MAX_EYES) {
            this.eyesContainingInventory.func_70299_a(this.eyeCount, stack.func_77979_a(1));
            ++this.eyeCount;
            this.func_70296_d();
            this.rangeBoosters = -1;
            return true;
        }
        return false;
    }

    public boolean itemIsValidEye(ItemStack stack) {
        return this.eyesContainingInventory.func_94041_b(this.eyeCount, stack);
    }

    public int getEyeCount() {
        return this.eyeCount;
    }

    public TileEntityUnseenScribe.SelectedContainers getSelectedContainers() {
        if (this.eyeCount > 0) {
            TileEntityUnseenScribe.SelectedContainers sc = new TileEntityUnseenScribe.SelectedContainers();
            for (int slot = 0; slot < this.eyeCount; ++slot) {
                WorldSpecificCoordinates coord;
                ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof IAutomagyLocationLink) || (coord = ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack)) == null || coord.x == this.field_145851_c && coord.y == this.field_145848_d - 1 && coord.z == this.field_145849_e) continue;
                sc.add(this.field_145850_b, coord.x, coord.y, coord.z);
            }
            return sc;
        }
        return null;
    }

    public int getRangeBoosters() {
        if (this.rangeBoosters == -1 && this.eyeCount > 0) {
            this.rangeBoosters = 0;
            for (int slot = 0; slot < this.eyeCount; ++slot) {
                WorldSpecificCoordinates coord;
                ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
                if (stack == null || !(stack.func_77973_b() instanceof IAutomagyLocationLink) || (coord = ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack)) == null || coord.x != this.field_145851_c || coord.y != this.field_145848_d - 1 || coord.z != this.field_145849_e) continue;
                ++this.rangeBoosters;
            }
        }
        return this.rangeBoosters;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.eyesContainingInventory.writeCustomNBT(nbttagcompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.eyesContainingInventory.readCustomNBT(nbttagcompound);
        this.eyeCount = 0;
        int size = this.eyesContainingInventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (this.eyesContainingInventory.func_70301_a(i) == null) continue;
            ++this.eyeCount;
        }
        this.displayChangedTick = -1;
        this.rangeBoosters = -1;
    }

    public boolean shouldRenderInPass(int pass) {
        BlockScribePointerRenderer.renderPass = pass;
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.5), (double)(this.field_145849_e + 1));
        return bb;
    }
}

