/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.events;

import com.github.namikon.blocklimiter.BlockLimiter;
import com.github.namikon.blocklimiter.auxiliary.BlockInfo;
import com.github.namikon.blocklimiter.config.BlockLimiterConfig;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPlaceEvent {
    private BlockLimiterConfig _mConfig = null;
    private Random _mRnd = null;

    public BlockPlaceEvent(BlockLimiterConfig pCfgMan) {
        this._mConfig = pCfgMan;
        this._mRnd = new Random();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.player.field_71075_bZ.field_75098_d && !BlockLimiter.Config.DenyCreativeMode) {
            return;
        }
        GameRegistry.UniqueIdentifier tBlockDomain = GameRegistry.findUniqueIdentifierFor((Block)event.block);
        BlockLimiter.Logger.debug((Object)("BlockPlaceEvent: " + tBlockDomain.modId + ":" + tBlockDomain.name + " in Dim " + event.player.field_71093_bK));
        for (BlockInfo tBI : this._mConfig.LimitedBlocks) {
            if (!tBI.isDenied(tBlockDomain, event.player.field_71093_bK)) continue;
            event.setCanceled(true);
            try {
                if (BlockLimiter.Config.SFXOnBlockDeny.length() > 0) {
                    event.world.func_72956_a((Entity)event.player, BlockLimiter.Config.SFXOnBlockDeny, 1.0f, 1.0f);
                }
                int tMsgIdx = this._mRnd.nextInt(BlockLimiter.Config.RandomDenyMessages.length);
                PlayerChatHelper.SendNotifyWarning((EntityPlayer)event.player, (String)BlockLimiter.Config.RandomDenyMessages[tMsgIdx]);
            }
            catch (Exception e) {
                BlockLimiter.Logger.error((Object)"Prevented ServerCrash caused by malformed RejectMessage or SoundSetting in the config file");
            }
            return;
        }
    }
}

