/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.data;

import chylex.hee.entity.technical.EntityTechnicalBiomeInteraction;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class AbstractBiomeInteraction {
    String identifier;
    protected EntityTechnicalBiomeInteraction entity;
    protected World world;
    protected Random rand;
    protected int centerX;
    protected int centerY;
    protected int centerZ;

    public final void init(EntityTechnicalBiomeInteraction entity) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.rand = entity.field_70170_p.field_73012_v;
        this.centerX = MathUtil.floor(entity.field_70165_t);
        this.centerY = MathUtil.floor(entity.field_70163_u);
        this.centerZ = MathUtil.floor(entity.field_70161_v);
    }

    public abstract void init();

    public abstract void update();

    public abstract void saveToNBT(NBTTagCompound var1);

    public abstract void loadFromNBT(NBTTagCompound var1);

    public String getIdentifier() {
        return this.identifier;
    }

    protected final AxisAlignedBB getIslandBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.centerX - 104), (double)10.0, (double)(this.centerZ - 104), (double)(this.centerX + 104), (double)120.0, (double)(this.centerZ + 104));
    }

    public static final class BiomeInteraction {
        private static final Map<String, BiomeInteraction> idLookup = new HashMap<String, BiomeInteraction>();
        private final String identifier;
        private final Class<? extends AbstractBiomeInteraction> interactionClass;
        private final int rngSource;
        private final byte maxInstances;

        public static AbstractBiomeInteraction createByIdentifier(String identifier) {
            BiomeInteraction interaction = idLookup.get(identifier);
            return interaction == null ? null : interaction.create();
        }

        public BiomeInteraction(String identifier, Class<? extends AbstractBiomeInteraction> interactionClass, int rngSource, int maxInstances) {
            this.identifier = identifier;
            this.interactionClass = interactionClass;
            this.rngSource = rngSource;
            this.maxInstances = (byte)(maxInstances > 127 ? 127 : maxInstances);
            idLookup.put(identifier, this);
        }

        public AbstractBiomeInteraction create() {
            try {
                AbstractBiomeInteraction interaction = this.interactionClass.newInstance();
                interaction.identifier = this.identifier;
                return interaction;
            }
            catch (IllegalAccessException | InstantiationException e) {
                Log.throwable(e, "Could not create Biome Island Interaction ($0).", this.interactionClass.getSimpleName());
                return null;
            }
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public int getRNG() {
            return this.rngSource;
        }

        public int getMaxInstances() {
            return this.maxInstances;
        }
    }
}

