/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.system;

import chylex.hee.system.collections.CustomArrayList;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import java.util.Random;

public class CollectionTests {
    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testCustomArrayList() {
        CustomArrayList<String> customArrayList = new CustomArrayList<String>();
        customArrayList.add("Entry 1");
        customArrayList.add("Entry 2");
        customArrayList.addAll(new String[]{"Entry 3", "Entry 4"});
        Assert.equal(customArrayList.size(), 4, "Unexpected list size, expected $2, got $1.");
        Assert.equal(customArrayList.get(2), "Entry 3", "Unexpected list entry, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testWeightedList() {
        WeightedList list = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
        Assert.isNull(list.getRandomItem(new Random()), "Unexpected list return value, expected null, got $.");
        list.add(ObjectWeightPair.of("Herp", 0x7FFFFFFE));
        list.add(ObjectWeightPair.of("Derp", 1));
        Assert.equal(list.size(), 2, "Unexpected list size, expected $2, got $1.");
        Assert.equal(((ObjectWeightPair)list.getRandomItem(new Random())).getObject(), "Herp", "Unexpected list return value, expected $2, got $1. Either broken or extremely unlucky.");
    }
}

