/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.implementations.tiles.ISoundP2PHandler;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.hooks.SoundEventHandler;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnelNormal;
import com.gtnewhorizon.gtnhlib.capability.Capabilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PartP2PSound
extends PartP2PTunnelNormal<PartP2PSound>
implements IGridTickable {
    private boolean alive = false;
    private ISoundP2PHandler customHandler;

    public PartP2PSound(ItemStack is) {
        super(is);
    }

    @Override
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    public void onNeighborChanged() {
        ISoundP2PHandler handler;
        TileEntity te = this.getTile();
        World w = te.func_145831_w();
        TileEntity neighbor = w.func_147438_o(te.field_145851_c + this.getSide().offsetX, te.field_145848_d + this.getSide().offsetY, te.field_145849_e + this.getSide().offsetZ);
        if (this.alive && !this.isOutput()) {
            SoundEventHandler.INSTANCE.activateP2P(this);
        }
        if ((handler = (ISoundP2PHandler)Capabilities.getCapability((TileEntity)neighbor, ISoundP2PHandler.class)) != null) {
            this.customHandler = handler;
            handler.onSoundP2PAttach(this);
        } else {
            this.customHandler = null;
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.alive = true;
        this.onNeighborChanged();
    }

    @Override
    public void removeFromWorld() {
        if (this.customHandler != null) {
            this.customHandler.onSoundP2PDetach(this);
        }
        super.removeFromWorld();
        this.alive = false;
        SoundEventHandler.INSTANCE.deactivateP2P(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150323_B.func_149733_h(0);
    }

    @Override
    public void onTunnelConfigChange() {
        this.onTunnelNetworkChange();
    }

    @Override
    public void onTunnelNetworkChange() {
        this.onNeighborChanged();
        if (this.customHandler != null) {
            try {
                this.customHandler.onSoundP2POutputUpdate(this, this.getOutputs());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.SoundTunnel.getMin(), TickRates.SoundTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.onNeighborChanged();
        return TickRateModulation.SLOWER;
    }

    @Nullable
    public ISoundP2PHandler getCustomHandler() {
        return this.customHandler;
    }

    public void proxyCall(BiConsumer<DimensionalCoord, World> runAtOutput) {
        if (this.getProxy() == null || !this.getProxy().isActive() || this.isOutput()) {
            return;
        }
        if (this.customHandler != null && !this.customHandler.allowSoundProxying(this)) {
            return;
        }
        try {
            this.getOutputs().forEach(output -> {
                if (output.getTile() == null || output.getProxy() == null || !output.getProxy().isActive()) {
                    return;
                }
                DimensionalCoord outputPos = output.getLocation();
                outputPos.add(output.getSide(), 1);
                runAtOutput.accept(outputPos, output.getTile().func_145831_w());
            });
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

