/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.blocks.detector.DetectorFilter;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.slots.ISlotController;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DetectorItem
extends DetectorFilter {
    private PrimaryMode primaryMode = PrimaryMode.ANYTHING;
    private FilterMode filterMode = FilterMode.AT_LEAST;

    public DetectorItem() {
        super(9);
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        block8: for (EntityMinecart cart : carts) {
            IInventory cartInv = null;
            if (cart instanceof IInventory) {
                cartInv = (IInventory)cart;
            }
            if (cartInv == null || cartInv.func_70302_i_() <= 0) continue;
            switch (this.primaryMode) {
                case ANYTHING: {
                    return 15;
                }
                case EMPTY: {
                    if (!InvTools.isInventoryEmpty(cartInv)) continue block8;
                    return 15;
                }
                case FULL: {
                    if (!InvTools.isInventoryFull(cartInv)) continue block8;
                    return 15;
                }
                case FILTERED: {
                    if (!this.matchesFilter(cartInv)) continue block8;
                    return 15;
                }
                case NOT_EMPTY: {
                    if (InvTools.isInventoryEmpty(cartInv)) continue block8;
                    return 15;
                }
                case ANALOG: {
                    return Container.func_94526_b((IInventory)cartInv);
                }
            }
        }
        return 0;
    }

    private boolean matchesFilter(IInventory cartInv) {
        block7: for (int i = 0; i < this.getFilters().func_70302_i_(); ++i) {
            ItemStack filter = this.getFilters().func_70301_a(i);
            if (filter == null) continue;
            int amountFilter = InvTools.countItems((IInventory)this.getFilters(), filter);
            int amountCart = InvTools.countItems(cartInv, filter);
            switch (this.filterMode) {
                case EXACTLY: {
                    if (amountCart == amountFilter) continue block7;
                    return false;
                }
                case AT_LEAST: {
                    if (amountCart >= amountFilter) continue block7;
                    return false;
                }
                case AT_MOST: {
                    if (amountCart <= amountFilter) continue block7;
                    return false;
                }
                case GREATER_THAN: {
                    if (amountCart > amountFilter) continue block7;
                    return false;
                }
                case LESS_THAN: {
                    if (amountCart < amountFilter) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("primaryMode", (byte)this.primaryMode.ordinal());
        data.func_74774_a("filterMode", (byte)this.filterMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.primaryMode = PrimaryMode.values()[data.func_74771_c("primaryMode")];
        this.filterMode = FilterMode.values()[data.func_74771_c("filterMode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_ITEM, player);
        return true;
    }

    public PrimaryMode getPrimaryMode() {
        return this.primaryMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setPrimaryMode(PrimaryMode primaryMode) {
        this.primaryMode = primaryMode;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public ISlotController getSlotController() {
        return new ISlotController(){

            @Override
            public boolean isSlotEnabled() {
                return DetectorItem.this.getPrimaryMode() == PrimaryMode.FILTERED;
            }
        };
    }

    @Override
    public EnumDetector getType() {
        return EnumDetector.ITEM;
    }

    public static enum PrimaryMode {
        EMPTY,
        FULL,
        ANYTHING,
        FILTERED,
        NOT_EMPTY,
        ANALOG;


        public String toString() {
            return LocalizationPlugin.translate("railcraft.gui.detector.item." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static enum FilterMode {
        AT_LEAST,
        AT_MOST,
        EXACTLY,
        LESS_THAN,
        GREATER_THAN;


        public String toString() {
            return LocalizationPlugin.translate("railcraft.gui.detector.item." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

