/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTileBlockColored;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class SubContainerChisel
extends SubContainer {
    public SubContainerChisel(EntityPlayer player) {
        super(player);
    }

    @Override
    public void createControls() {
    }

    @Override
    public void onGuiPacket(int controlID, NBTTagCompound nbt, EntityPlayer player) {
        if (controlID == 0) {
            int firstX = nbt.func_74762_e("x1");
            int firstY = nbt.func_74762_e("y1");
            int firstZ = nbt.func_74762_e("z1");
            int secX = nbt.func_74762_e("x2");
            int secY = nbt.func_74762_e("y2");
            int secZ = nbt.func_74762_e("z2");
            int minX = Math.min(firstX, secX);
            int maxX = Math.max(firstX, secX);
            int minY = Math.min(firstY, secY);
            int maxY = Math.max(firstY, secY);
            int minZ = Math.min(firstZ, secZ);
            int maxZ = Math.max(firstZ, secZ);
            boolean colorize = nbt.func_74764_b("color");
            int color = nbt.func_74762_e("color");
            Block filter = null;
            int meta = -1;
            if (nbt.func_74764_b("filterBlock")) {
                filter = Block.func_149684_b((String)nbt.func_74779_i("filterBlock"));
                if (nbt.func_74764_b("filterMeta")) {
                    meta = nbt.func_74762_e("filterMeta");
                }
            }
            Block replacement = null;
            int metaReplacement = -1;
            if (nbt.func_74764_b("replaceBlock")) {
                replacement = Block.func_149684_b((String)nbt.func_74779_i("replaceBlock"));
                if (nbt.func_74764_b("replaceMeta")) {
                    metaReplacement = nbt.func_74762_e("replaceMeta");
                }
            }
            int effected = 0;
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        TileEntity tileEntity = player.field_70170_p.func_147438_o(posX, posY, posZ);
                        boolean hasChanged = false;
                        if (!(tileEntity instanceof TileEntityLittleTiles)) continue;
                        TileEntityLittleTiles littleEntity = (TileEntityLittleTiles)tileEntity;
                        List<LittleTile> tiles = littleEntity.getTiles();
                        for (int i = 0; i < tiles.size(); ++i) {
                            LittleTileBlock newTile;
                            boolean shouldEffect;
                            LittleTile tile = tiles.get(i);
                            boolean bl = shouldEffect = tile.getClass() == LittleTileBlock.class || tile instanceof LittleTileBlockColored;
                            if (filter != null) {
                                if (((LittleTileBlock)tile).block != filter) {
                                    shouldEffect = false;
                                }
                                if (meta != -1 && ((LittleTileBlock)tile).meta != meta) {
                                    shouldEffect = false;
                                }
                            }
                            if (!shouldEffect) continue;
                            hasChanged = true;
                            if (replacement != null) {
                                ((LittleTileBlock)tile).block = replacement;
                                if (metaReplacement != -1) {
                                    ((LittleTileBlock)tile).meta = metaReplacement;
                                }
                                littleEntity.needFullUpdate = true;
                            }
                            if (colorize && (newTile = LittleTileBlockColored.setColor((LittleTileBlock)tile, color)) != null) {
                                tiles.set(i, newTile);
                            }
                            ++effected;
                        }
                        if (!hasChanged) continue;
                        littleEntity.update();
                    }
                }
            }
            player.func_145747_a((IChatComponent)new ChatComponentText("Done! Effected " + effected + " tiles!"));
        }
    }
}

