/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tinkers;

import com.arc.bloodarsenal.common.tinkers.TextureResourcePackBase;
import java.awt.image.BufferedImage;
import net.minecraft.util.MathHelper;

public class TextureResourcePackBloodInfusedIron
extends TextureResourcePackBase {
    static int[][] offsets = new int[][]{{0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}, {-1, 1}};

    public TextureResourcePackBloodInfusedIron(String name) {
        super(name);
    }

    @Override
    public BufferedImage modifyImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        image.getType();
        int[][] pixels = new int[w][h];
        boolean[][] base = new boolean[w][h];
        int mean = 0;
        int div = 0;
        for (int n = 0; n < w; ++n) {
            for (int baseSilhouette = 0; baseSilhouette < h; ++baseSilhouette) {
                boolean baseCorners;
                int interior1 = image.getRGB(n, baseSilhouette);
                pixels[n][baseSilhouette] = this.brightness(interior1);
                boolean bl = baseCorners = interior1 != 0 && rgb.getAlpha(interior1) > 64;
                if (!baseCorners) continue;
                base[n][baseSilhouette] = true;
                mean += pixels[n][baseSilhouette];
                ++div;
            }
        }
        mean = mean / div * 2 / 4;
        int var26 = w >= 256 ? 5 : (w >= 128 ? 4 : (w >= 64 ? 3 : (w >= 32 ? 2 : 1)));
        boolean[][] var27 = this.contract(base, var26);
        boolean[][] var28 = this.contract(var27, var26);
        boolean[][] interior2 = this.contract(var28, 2 * var26);
        boolean[][] interior3 = this.contract(interior2, var26);
        boolean[][] interior4 = this.contract(interior3, var26);
        boolean[][] interiorCorners = this.multI(this.mult(this.expand(this.getCorners(interior2), var26), interior2), interior3);
        boolean[][] interiorCornersShift = this.orwise(this.orwise(this.shift(interiorCorners, -1, 0), this.shift(interiorCorners, 0, -1)), this.shift(interiorCorners, -1, -1));
        int trans = 0;
        int red = 0xFF9D9D;
        int pink_highlight = 0xFF9D9D;
        int iron = 0xFF9D9D;
        int darkiron = 13592423;
        int[][] outpixels = new int[w][w];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                outpixels[x][y] = !var27[x][y] ? (base[x][y] ? this.multPixel(darkiron, pixels[x][y] / 2) : trans) : (interior2[x][y] && !interior3[x][y] ? (interiorCorners[x][y] ? (interiorCornersShift[x][y] ? this.multPixel(red, Math.max(pixels[x][y], mean)) : this.multPixel(pink_highlight, Math.max(pixels[x][y], mean) + 5)) : this.multPixel(red, pixels[x][y])) : this.multPixel(iron, pixels[x][y]));
                image.setRGB(x, y, outpixels[x][y]);
            }
        }
        return image;
    }

    private boolean[][] orwise(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] | b[i][j];
            }
        }
        return a;
    }

    private boolean[][] mult(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] & b[i][j];
            }
        }
        return a;
    }

    private boolean[][] multI(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] & !b[i][j];
            }
        }
        return a;
    }

    private boolean[][] expand(boolean[][] base, int n) {
        boolean[][] output = this.expand(base);
        for (int i = 0; i < n - 1; ++i) {
            output = this.expand(output);
        }
        return output;
    }

    private boolean[][] contract(boolean[][] base, int n) {
        boolean[][] output = this.contract(base);
        for (int i = 0; i < n - 1; ++i) {
            output = this.contract(output);
        }
        return output;
    }

    public int multPixel(int col, int b) {
        return 0xFF000000 | this.clamp(rgb.getRed(col) * b / 255) << 16 | this.clamp(rgb.getGreen(col) * b / 255) << 8 | this.clamp(rgb.getBlue(col) * b / 255);
    }

    private int clamp(int i) {
        return MathHelper.func_76125_a((int)i, (int)0, (int)255);
    }

    public boolean get(boolean[][] img, int x, int y) {
        return x >= 0 && y >= 0 && x < img.length && y < img[x].length && img[x][y];
    }

    public boolean[][] shift(boolean[][] img, int dx, int dy) {
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (int x = Math.max(-dx, 0); x < Math.min(w, w + dx); ++x) {
            System.arraycopy(img[x + dx], Math.max(-dy, 0) + dy, img2[x], Math.max(-dy, 0), Math.min(w, w + dy) - Math.max(-dy, 0));
        }
        return img2;
    }

    public boolean[][] getCorners(boolean[][] img) {
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (!img[x][y]) continue;
                int an = -1;
                int n = 0;
                for (int[] offset : offsets) {
                    if (this.get(img, x + offset[0], y + offset[1])) {
                        if (an == -1) {
                            an = n;
                        }
                        n = 0;
                        continue;
                    }
                    if (++n == 5) break;
                }
                if (an != -1) {
                    n += an;
                }
                if (n < 5) continue;
                img2[x][y] = true;
            }
        }
        return img2;
    }

    public boolean[][] contract(boolean[][] img) {
        int x;
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (x = 0; x < w; ++x) {
            System.arraycopy(img[x], 0, img2[x], 0, w);
        }
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (img[x][y]) {
                    if (x != 0 && y != 0 && x != w - 1 && y != w - 1) continue;
                    img2[x][y] = false;
                    continue;
                }
                if (x > 0) {
                    img2[x - 1][y] = false;
                }
                if (y > 0) {
                    img2[x][y - 1] = false;
                }
                if (x < w - 1) {
                    img2[x + 1][y] = false;
                }
                if (y >= w - 1) continue;
                img2[x][y + 1] = false;
            }
        }
        return img2;
    }

    public boolean[][] expand(boolean[][] img) {
        int x;
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (x = 0; x < w; ++x) {
            System.arraycopy(img[x], 0, img2[x], 0, w);
        }
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (!img[x][y]) continue;
                for (int[] offset : offsets) {
                    int dx = x + offset[0];
                    int dy = y + offset[1];
                    if (dx < 0 || dy < 0 || dx >= w || dy >= w) continue;
                    img2[dx][dy] = true;
                }
            }
        }
        return img2;
    }
}

