/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.objectTag;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.glease.tc4tweak.modules.generateItemHash.GenerateItemHash;
import net.glease.tc4tweak.modules.objectTag.ObjectTagsCache;
import net.glease.tc4tweak.modules.objectTag.ObjectTagsMutation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class GetObjectTags {
    static final Logger log = LogManager.getLogger((String)"GetObjectTags");
    private static final ObjectTagsCache cache = new ObjectTagsCache();

    public static ConcurrentHashMap<List, AspectList> newReplacementObjectTagsMap() {
        return new InterceptingConcurrentHashMap();
    }

    public static Stream<Map.Entry<ItemStack, AspectList>> stream() {
        if (cache.isEnabled()) {
            return ((ConcurrentMap)cache.getCache()).entrySet().stream().flatMap(e -> StreamSupport.stream(Spliterators.spliterator(GetObjectTags.iterate((Item)e.getKey(), (TIntObjectMap<AspectList>)((TIntObjectMap)e.getValue())), (long)((TIntObjectMap)e.getValue()).size(), 257), false));
        }
        return Stream.empty();
    }

    private static Iterator<Map.Entry<ItemStack, AspectList>> iterate(final Item owner, TIntObjectMap<AspectList> all) {
        final TIntObjectIterator backing = all.iterator();
        return new Iterator<Map.Entry<ItemStack, AspectList>>(){

            @Override
            public boolean hasNext() {
                return backing.hasNext();
            }

            @Override
            public Map.Entry<ItemStack, AspectList> next() {
                backing.advance();
                return Pair.of((Object)new ItemStack(owner, 1, backing.key()), (Object)backing.value());
            }
        };
    }

    public static AspectList getObjectTags(ItemStack itemstack) {
        int meta;
        Item item;
        try {
            item = itemstack.func_77973_b();
            meta = itemstack.func_77960_j();
        }
        catch (Exception e) {
            return null;
        }
        if (item == null) {
            return null;
        }
        AspectList tmp = GetObjectTags.getBaseObjectTags(item, meta);
        if (tmp == null) {
            tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(item, meta));
        }
        if (tmp == null) {
            for (List l : ThaumcraftApi.objectTags.keySet()) {
                if (l.get(0) != item || !(l.get(1) instanceof int[])) continue;
                int[] range = (int[])l.get(1);
                Arrays.sort(range);
                if (Arrays.binarySearch(range, meta) < 0) continue;
                tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(item, range));
                return tmp;
            }
            tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(item, Short.MAX_VALUE));
            if (tmp == null) {
                if (meta == Short.MAX_VALUE) {
                    for (int index = 0; index < 16 && (tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(item, index))) == null; ++index) {
                    }
                }
                if (tmp == null) {
                    tmp = ThaumcraftCraftingManager.generateTags((Item)item, (int)meta);
                }
            }
        }
        if (itemstack.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
            if (tmp == null) {
                tmp = new AspectList();
            }
            GetObjectTags.addWandTags(itemstack, tmp, wand);
        } else if (item == Items.field_151068_bn) {
            if (tmp == null) {
                tmp = new AspectList();
            }
            GetObjectTags.addPotionTags(itemstack, (ItemPotion)item, tmp);
        }
        if (tmp == null) {
            return null;
        }
        for (Integer size : tmp.aspects.values()) {
            if (size <= 64) continue;
            return GetObjectTags.truncateAspectList(tmp);
        }
        return tmp;
    }

    private static AspectList truncateAspectList(AspectList tmp) {
        AspectList out = tmp.copy();
        out.aspects.replaceAll((a, n) -> Math.min(64, n));
        return out;
    }

    private static void addWandTags(ItemStack itemstack, AspectList tmp, ItemWandCasting wand) {
        tmp.merge(Aspect.MAGIC, (wand.getRod(itemstack).getCraftCost() + wand.getCap(itemstack).getCraftCost()) / 2);
        tmp.merge(Aspect.TOOL, (wand.getRod(itemstack).getCraftCost() + wand.getCap(itemstack).getCraftCost()) / 3);
    }

    private static void addPotionTags(ItemStack itemstack, ItemPotion item, AspectList tmp) {
        tmp.merge(Aspect.WATER, 1);
        List effects = item.func_77834_f(itemstack.func_77960_j());
        if (effects != null) {
            if (ItemPotion.func_77831_g((int)itemstack.func_77960_j())) {
                tmp.merge(Aspect.ENTROPY, 2);
            }
            for (PotionEffect effect : effects) {
                int amplifier = effect.func_76458_c();
                int potionID = effect.func_76456_a();
                tmp.merge(Aspect.MAGIC, (amplifier + 1) * 2);
                if (potionID == Potion.field_76440_q.field_76415_H) {
                    tmp.merge(Aspect.DARKNESS, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76431_k.field_76415_H) {
                    tmp.merge(Aspect.ELDRITCH, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76420_g.field_76415_H) {
                    tmp.merge(Aspect.WEAPON, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76419_f.field_76415_H) {
                    tmp.merge(Aspect.TRAP, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76422_e.field_76415_H) {
                    tmp.merge(Aspect.TOOL, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76426_n.field_76415_H) {
                    tmp.merge(Aspect.ARMOR, amplifier + 1);
                    tmp.merge(Aspect.FIRE, (amplifier + 1) * 2);
                    continue;
                }
                if (potionID == Potion.field_76433_i.field_76415_H) {
                    tmp.merge(Aspect.DEATH, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76432_h.field_76415_H) {
                    tmp.merge(Aspect.HEAL, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76438_s.field_76415_H) {
                    tmp.merge(Aspect.DEATH, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76441_p.field_76415_H) {
                    tmp.merge(Aspect.SENSES, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76430_j.field_76415_H) {
                    tmp.merge(Aspect.FLIGHT, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76421_d.field_76415_H) {
                    tmp.merge(Aspect.TRAP, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76424_c.field_76415_H) {
                    tmp.merge(Aspect.MOTION, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76439_r.field_76415_H) {
                    tmp.merge(Aspect.SENSES, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76436_u.field_76415_H) {
                    tmp.merge(Aspect.POISON, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76428_l.field_76415_H) {
                    tmp.merge(Aspect.HEAL, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76429_m.field_76415_H) {
                    tmp.merge(Aspect.ARMOR, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID == Potion.field_76427_o.field_76415_H) {
                    tmp.merge(Aspect.AIR, (amplifier + 1) * 3);
                    continue;
                }
                if (potionID != Potion.field_76437_t.field_76415_H) continue;
                tmp.merge(Aspect.DEATH, (amplifier + 1) * 3);
            }
        }
    }

    @Nullable
    private static AspectList getBaseObjectTags(Item item, int meta) {
        AspectList aspectList;
        ConcurrentMap cache = (ConcurrentMap)GetObjectTags.cache.getCache();
        if (cache == null) {
            return null;
        }
        TIntObjectMap submap = (TIntObjectMap)cache.get(item);
        if (submap != null) {
            aspectList = (AspectList)submap.get(meta);
            if (aspectList != null) {
                return aspectList;
            }
            aspectList = (AspectList)submap.get(Short.MAX_VALUE);
            if (aspectList != null) {
                return aspectList;
            }
            if (meta == Short.MAX_VALUE) {
                for (int i = 0; i < 16; ++i) {
                    aspectList = (AspectList)submap.get(i);
                    if (aspectList == null) continue;
                    return aspectList;
                }
            }
        }
        return (aspectList = ThaumcraftCraftingManager.generateTags((Item)item, (int)meta)) == null ? new AspectList() : aspectList;
    }

    static void mutateObjectTagsSubmap(List<?> key, ObjectTagsMutation action) {
        ConcurrentMap cache = (ConcurrentMap)GetObjectTags.cache.getCache();
        if (cache != null) {
            Item item = (Item)key.get(0);
            if (key.get(1) instanceof int[]) {
                int[] metas = (int[])key.get(1);
                TIntObjectMap submap = cache.computeIfAbsent(item, k -> new TIntObjectHashMap(metas.length));
                for (int meta : metas) {
                    action.accept((TIntObjectMap<AspectList>)submap, meta);
                }
            } else if (key.get(1) instanceof Integer) {
                action.accept((TIntObjectMap<AspectList>)cache.computeIfAbsent(item, k -> new TIntObjectHashMap()), (Integer)key.get(1));
            }
        }
    }

    @ParametersAreNonnullByDefault
    static class InterceptingConcurrentHashMap
    extends ConcurrentHashMap<List, AspectList> {
        InterceptingConcurrentHashMap() {
        }

        @Override
        public AspectList put(List key, AspectList value) {
            GetObjectTags.mutateObjectTagsSubmap(key, (submap, meta) -> {
                AspectList cfr_ignored_0 = (AspectList)submap.put(meta, (Object)value);
            });
            GenerateItemHash.onNewObjectTag(key);
            return super.put(key, value);
        }

        @Override
        public AspectList remove(Object key) {
            if (key instanceof List) {
                List key1 = (List)key;
                GetObjectTags.mutateObjectTagsSubmap(key1, TIntObjectMap::remove);
                GenerateItemHash.onRemoveObjectTag(key1);
            }
            return (AspectList)super.remove(key);
        }

        @Override
        public boolean remove(Object key, Object value) {
            if (key instanceof List && value instanceof AspectList) {
                List key1 = (List)key;
                GetObjectTags.mutateObjectTagsSubmap(key1, (submap, meta) -> {
                    if (value.equals(submap.get(meta))) {
                        submap.remove(meta);
                    }
                });
                GenerateItemHash.onRemoveObjectTag(key1);
            }
            return super.remove(key, value);
        }
    }
}

