/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityFlag;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.Orientation;
import openmods.utils.ColorUtils;

public class BlockFlag
extends OpenBlock {
    public static final ColorUtils.RGB[] COLORS = new ColorUtils.RGB[]{new ColorUtils.RGB(20, 198, 0), new ColorUtils.RGB(41, 50, 156), new ColorUtils.RGB(221, 0, 0), new ColorUtils.RGB(255, 174, 201), new ColorUtils.RGB(185, 122, 87), new ColorUtils.RGB(181, 230, 29), new ColorUtils.RGB(0, 162, 232), new ColorUtils.RGB(128, 0, 64), new ColorUtils.RGB(255, 242, 0), new ColorUtils.RGB(255, 127, 39), new ColorUtils.RGB(255, 45, 45), new ColorUtils.RGB(255, 23, 151), new ColorUtils.RGB(195, 195, 195), new ColorUtils.RGB(163, 73, 164), new ColorUtils.RGB(0, 0, 0), new ColorUtils.RGB(255, 255, 255)};

    public BlockFlag() {
        super(Material.field_151594_q);
        this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
        this.setRotationMode(BlockRotationMode.SIX_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.setInventoryRenderOrientation(Orientation.XN_YN);
        this.setRenderMode(OpenBlock.RenderMode.TESR_ONLY);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityFlag flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityFlag.class));
        if (flag != null) {
            ForgeDirection onSurface = flag.getOrientation().down();
            if (onSurface == ForgeDirection.DOWN) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
            } else if (onSurface == ForgeDirection.EAST || onSurface == ForgeDirection.WEST) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.3125f, 1.0f, 0.0625f);
            } else {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.3125f);
            }
        }
    }

    public boolean canPlaceBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection sideDir, Orientation orientation, float hitX, float hitY, float hitZ, int newMeta) {
        return this.checkBlock(world, x, y, z, orientation);
    }

    private boolean checkBlock(World world, int x, int y, int z, Orientation orientation) {
        Block belowBlock;
        if (orientation == Orientation.XN_YN) {
            return false;
        }
        if (orientation == Orientation.XP_YP && (belowBlock = world.func_147439_a(x, y - 1, z)) != null) {
            TileEntityFlag flag;
            if (belowBlock == Blocks.field_150422_aJ) {
                return true;
            }
            if (belowBlock == this && (flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)(y - 1), (int)z, TileEntityFlag.class))) != null && flag.getOrientation().down() == ForgeDirection.DOWN) {
                return true;
            }
        }
        return BlockFlag.isNeighborBlockSolid((IBlockAccess)world, (int)x, (int)y, (int)z, (ForgeDirection)orientation.down());
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        super.func_149695_a(world, x, y, z, neighbour);
        int metadata = world.func_72805_g(x, y, z);
        Orientation orientation = this.getOrientation(metadata);
        if (!this.checkBlock(world, x, y, z, orientation)) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public boolean canRotateWithTool() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = registry.func_94245_a("planks_oak");
    }
}

