/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiRecipe;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class AbstractSubpanel<T extends ItemsGrid<? extends ItemsGrid.ItemsGridSlot, ? extends ItemsGrid.MouseContext>>
extends Widget
implements IContainerTooltipHandler {
    final DrawableResource DASH = new DrawableBuilder("nei:textures/dash.png", 0, 0, 6, 1).setTextureSize(6, 1).build();
    protected int mouseDownItemIndex = -1;
    protected int splittingLineColor = -1;
    protected int linePaddingStart = 0;
    protected T grid;

    public boolean isEmpty() {
        return ((ItemsGrid)this.grid).isEmpty();
    }

    @Override
    public void draw(int mousex, int mousey) {
        this.drawSplittingLine();
        ((ItemsGrid)this.grid).draw(mousex, mousey);
    }

    @Override
    public void update() {
        ((ItemsGrid)this.grid).update();
    }

    public abstract int setPanelWidth(int var1);

    public void resize(GuiContainer gui) {
        ((ItemsGrid)this.grid).setGridSize(this.x, this.y + 4, this.w, this.h - 8);
        ((ItemsGrid)this.grid).refresh(gui);
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemsGrid.ItemsGridSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.getItemStack();
    }

    public ItemsGrid.ItemsGridSlot getSlotMouseOver(int mousex, int mousey) {
        return ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey);
    }

    protected void updateLinePadding() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        this.linePaddingStart = 0;
        while (GuiInfo.hideItemPanelSlot(guiContainer, new Rectangle4i(this.x + this.linePaddingStart, this.y - 1, 10, 2))) {
            this.linePaddingStart += 10;
        }
    }

    protected void drawSplittingLine() {
        float alpha = (float)(this.splittingLineColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.splittingLineColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.splittingLineColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.splittingLineColor & 0xFF) / 255.0f;
        int width = ((ItemsGrid)this.grid).columns * ItemsGrid.SLOT_SIZE - this.linePaddingStart;
        int repeat = width / 6;
        int shiftX = this.x + this.linePaddingStart + (this.w - width) / 2;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        for (int i = 0; i < repeat; ++i) {
            this.DASH.draw(shiftX + i * 6, this.y);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        ItemsGrid.ItemsGridSlot mouseOverSlot;
        if (this.mouseDownItemIndex >= 0 && ItemPanels.itemPanel.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && ((mouseOverSlot = this.getSlotMouseOver(mousex, mousey)) == null || mouseOverSlot.itemIndex != this.mouseDownItemIndex || heldTime > 500L)) {
            ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(((ItemsGrid)this.grid).getItem(this.mouseDownItemIndex));
            this.mouseDownItemIndex = -1;
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        Object hoverSlot = ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack());
            } else {
                this.mouseDownItemIndex = ((ItemsGrid.ItemsGridSlot)hoverSlot).itemIndex;
            }
            return true;
        }
        return false;
    }

    protected abstract ItemStack getDraggedStackWithQuantity(ItemStack var1);

    public ItemStack getStackMouseOverWithQuantity(int mousex, int mousey) {
        ItemStack hoverSlot = this.getStackMouseOver(mousex, mousey);
        return hoverSlot != null ? this.getDraggedStackWithQuantity(hoverSlot) : null;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemsGrid.ItemsGridSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.itemIndex == this.mouseDownItemIndex && ItemPanels.itemPanel.draggedStack == null) {
            if (NEIController.manager.window instanceof GuiRecipe || NEIClientUtils.shiftKey() || !NEIClientConfig.canCheatItem(hoverSlot.getItemStack())) {
                ShortcutInputHandler.handleMouseClick(hoverSlot.getItemStack().func_77946_l());
            } else {
                NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(hoverSlot.getItemStack()), button, -1);
            }
        }
        this.mouseDownItemIndex = -1;
    }
}

