/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipeConstants;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ImplosionCompressor")
@ModOnly(value={"gregtech"})
public class ImplosionCompressor {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int tnt) {
        ImplosionCompressor.addRecipe(new IItemStack[]{output, null}, input, tnt);
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient input, int tnt) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"Implosion compressor recipe requires at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Implosion compressor recipe for " + output[0], new Object[]{input, tnt, output[0], ArrayHelper.itemOrNull(output, 1)}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input = i.nextItem();
                    int additiveAmount = i.nextInt();
                    ItemStack output1 = i.nextItem();
                    ItemStack output2 = i.nextItem();
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(output1, output2));
                    outputs.removeIf(Objects::isNull);
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(outputs.toArray(new ItemStack[0])).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, (Object)additiveAmount).addTo((IRecipeMap)RecipeMaps.implosionRecipes);
                }
            });
        }
    }
}

