/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.config;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import java.util.Collection;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ArchitectConfiguration
extends Configuration {
    public boolean extended = false;
    int nextVillagerID = 100;

    public ArchitectConfiguration(File file) {
        super(file);
    }

    public String getString(String category, String key, String defaultValue) {
        return this.get(category, key, defaultValue).getString();
    }

    public String[] getStringList(String category, String key, String ... defaultValueList) {
        String defaultValue = String.join((CharSequence)",", defaultValueList);
        String value = this.getString(category, key, defaultValue);
        return value.split(",");
    }

    public int getVillager(String key) {
        VillagerRegistry reg = VillagerRegistry.instance();
        Property prop = this.get("villagers", key, -1);
        int id = prop.getInt();
        if (id == -1) {
            id = this.allocateVillagerId(reg);
            prop.set(id);
        }
        reg.registerVillagerId(id);
        return id;
    }

    int allocateVillagerId(VillagerRegistry reg) {
        int id;
        Collection inUse = VillagerRegistry.getRegisteredVillagers();
        do {
            ++this.nextVillagerID;
        } while (inUse.contains(id));
        return id;
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        if (!this.hasKey(category, key)) {
            this.extended = true;
        }
        return super.get(category, key, defaultValue, comment, type);
    }
}

