/*
 * Decompiled with CFR 0.152.
 */
package drethic.questbook.config;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import drethic.questbook.logger.QBLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class QBConfig {
    public static Configuration qbconfig;
    public static QBConfig instance;
    public static boolean spawnWithBook;
    public static boolean disablePartyNotifications;
    public static boolean disableQuestNotifications;
    public static boolean fullySyncQuests;

    public static final void init(FMLPreInitializationEvent e) {
        QBLogger.logger.info("Loading config file.");
        qbconfig = new Configuration(new File(e.getModConfigurationDirectory().getAbsolutePath() + "/betterquesting/questbook.cfg"));
        qbconfig.load();
        qbconfig.addCustomCategoryComment("general", "General options for the Quest Book mod.");
        spawnWithBook = QBConfig.configBoolOption("general", "spawnWithBook", false, "Enable this option so new players will spawn with a Quest Book. Default: false");
        disablePartyNotifications = QBConfig.configBoolOption("general", "disablePartyNotifications", false, "[NYI]Disable party notifications.  Default: false");
        disableQuestNotifications = QBConfig.configBoolOption("general", "disableQuestNotifications", false, "[NYI]Disable quest notifications.  Default: false");
        fullySyncQuests = QBConfig.configBoolOption("general", "fullySyncQuests", false, "[NYI]Fully sync quests between party members, including quest rewards, checkbox quests, and [consume] retrieval quests.  Default: false");
        qbconfig.save();
    }

    public static boolean configBoolOption(String section, String name, boolean defaultValue, String comment) {
        Property spawnWithBookProperty = qbconfig.get(section, name, defaultValue);
        spawnWithBookProperty.comment = comment;
        return spawnWithBookProperty.getBoolean(defaultValue);
    }
}

