/*
 * Decompiled with CFR 0.152.
 */
package bq_standard;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1FPacketSetExperience;

public class XPHelper {
    private static long[] QUICK_XP = new long[2147];

    public static void addXP(EntityPlayer player, long xp) {
        XPHelper.addXP(player, xp, true);
    }

    public static void addXP(EntityPlayer player, long xp, boolean sync) {
        long experience = XPHelper.getPlayerXP(player) + xp;
        player.field_71067_cb = experience >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)experience;
        player.field_71068_ca = XPHelper.getXPLevel(experience);
        long expForLevel = XPHelper.getLevelXP(player.field_71068_ca);
        player.field_71106_cc = (float)((double)(experience - expForLevel) / (double)XPHelper.xpBarCap(player));
        player.field_71106_cc = Math.max(0.0f, player.field_71106_cc);
        if (sync && player instanceof EntityPlayerMP) {
            XPHelper.syncXP((EntityPlayerMP)player);
        }
    }

    public static void syncXP(EntityPlayerMP player) {
        player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
    }

    public static long getPlayerXP(EntityPlayer player) {
        return XPHelper.getLevelXP(player.field_71068_ca) + (long)((double)XPHelper.xpBarCap(player) * Math.max(0.0, (double)player.field_71106_cc));
    }

    public static long xpBarCap(EntityPlayer player) {
        if (player.field_71068_ca < 16) {
            return (long)(2.0 * (double)player.field_71068_ca + 7.0);
        }
        if (player.field_71068_ca < 31) {
            return (long)(5.0 * (double)player.field_71068_ca - 38.0);
        }
        return (long)(9.0 * (double)player.field_71068_ca - 158.0);
    }

    public static int getXPLevel(long xp) {
        int i;
        if (xp <= 0L) {
            return 0;
        }
        for (i = 0; i < QUICK_XP.length && QUICK_XP[i] <= xp; ++i) {
        }
        if (i > 0) {
            i = (i - 1) * 1000000;
        }
        while (i < Integer.MAX_VALUE && XPHelper.getLevelXP(i) <= xp) {
            ++i;
        }
        return i - 1;
    }

    public static long getLevelXP(int level) {
        if (level <= 0) {
            return 0L;
        }
        if (level < 16) {
            return level * 17;
        }
        if (level < 31) {
            return (long)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (long)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    static {
        for (int i = 0; i < QUICK_XP.length; ++i) {
            XPHelper.QUICK_XP[i] = XPHelper.getLevelXP(i * 1000000);
        }
    }
}

