/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetInviteSync;
import betterquesting.network.handlers.NetNameSync;
import betterquesting.network.handlers.NetPartySync;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class NetPartyAction {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:party_action");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetPartyAction::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetPartyAction::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendAction(NBTTagCompound payload) {
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        int partyID = !message.func_76341_a().func_150297_b("partyID", 99) ? -1 : message.func_76341_a().func_74762_e("partyID");
        IParty party = (IParty)PartyManager.INSTANCE.getValue(partyID);
        int permission = party == null ? 0 : NetPartyAction.checkPermission(QuestingAPI.getQuestingUUID((EntityPlayer)sender), party);
        switch (action) {
            case 0: {
                NetPartyAction.createParty(sender, message.func_76341_a().func_74779_i("name"));
                break;
            }
            case 1: {
                if (permission < 3) break;
                NetPartyAction.deleteParty(partyID);
                break;
            }
            case 2: {
                if (permission < 2) break;
                NetPartyAction.editParty(partyID, party, message.func_76341_a().func_74775_l("data"));
                break;
            }
            case 3: {
                if (permission < 2) break;
                NetPartyAction.inviteUser(partyID, message.func_76341_a().func_74779_i("username"), message.func_76341_a().func_74763_f("expiry"));
                break;
            }
            case 4: {
                NetPartyAction.acceptInvite(partyID, sender);
                break;
            }
            case 5: {
                NetPartyAction.kickUser(partyID, sender, party, message.func_76341_a().func_74779_i("username"), permission);
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid party action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    private static void createParty(EntityPlayerMP sender, String name) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
        if (PartyManager.INSTANCE.getParty(playerID) != null) {
            return;
        }
        int partyID = PartyManager.INSTANCE.nextID();
        IParty party = PartyManager.INSTANCE.createNew(partyID);
        party.getProperties().setProperty(NativeProps.NAME, name);
        party.setStatus(playerID, EnumPartyStatus.OWNER);
        NetPartySync.sendSync(new EntityPlayerMP[]{sender}, new int[]{partyID});
    }

    private static void deleteParty(int partyID) {
        PartyManager.INSTANCE.removeID(partyID);
        PartyInvitations.INSTANCE.purgeInvites(partyID);
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 1);
        payload.func_74768_a("partyID", partyID);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    private static void editParty(int partyID, IParty party, NBTTagCompound settings) {
        party.readProperties(settings);
        NetPartySync.quickSync(partyID);
    }

    private static void inviteUser(int partyID, String username, long expiry) {
        UUID uuid = null;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        EntityPlayerMP player = server.func_71203_ab().func_152612_a(username);
        if (player != null) {
            uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        }
        if (uuid == null) {
            uuid = NameCache.INSTANCE.getUUID(username);
        }
        if (uuid != null) {
            PartyInvitations.INSTANCE.postInvite(uuid, partyID, expiry);
            if (player != null) {
                NetPartySync.sendSync(new EntityPlayerMP[]{player}, new int[]{partyID});
                NetInviteSync.sendSync(player);
            }
        } else {
            BetterQuesting.logger.error("Unable to identify " + username + " to invite to party " + partyID);
        }
    }

    private static void acceptInvite(int partyID, EntityPlayerMP sender) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
        DBEntry<IParty> party = PartyManager.INSTANCE.getParty(playerID);
        if (party != null) {
            return;
        }
        if (PartyInvitations.INSTANCE.acceptInvite(playerID, partyID)) {
            NetPartySync.quickSync(partyID);
            NetNameSync.quickSync(sender, partyID);
        } else {
            BetterQuesting.logger.error("Invalid invite for " + sender.func_70005_c_() + " to party " + partyID);
        }
        NetInviteSync.sendSync(sender);
    }

    private static void kickUser(int partyID, EntityPlayerMP sender, IParty party, String username, int permission) {
        if (party == null) {
            BetterQuesting.logger.error("Tried to kick a player from a non-existant party (" + partyID + ")");
            return;
        }
        UUID uuid = null;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        EntityPlayerMP player = server.func_71203_ab().func_152612_a(username);
        if (player != null) {
            uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        }
        if (uuid == null) {
            uuid = NameCache.INSTANCE.getUUID(username);
        }
        if (uuid == null) {
            BetterQuesting.logger.error("Unable to identify " + username + " to remove them from party " + partyID);
            return;
        }
        if (uuid.equals(QuestingAPI.getQuestingUUID((EntityPlayer)sender)) || NetPartyAction.checkPermission(uuid, party) < permission) {
            if (party.getStatus(uuid) != null) {
                party.kickUser(uuid);
            }
            if (party.getMembers().size() > 0) {
                NetPartySync.quickSync(partyID);
                if (player != null) {
                    NBTTagCompound payload = new NBTTagCompound();
                    payload.func_74768_a("action", 5);
                    payload.func_74768_a("partyID", partyID);
                    PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
                }
            } else {
                PartyManager.INSTANCE.removeID(partyID);
                PartyInvitations.INSTANCE.purgeInvites(partyID);
                NBTTagCompound payload = new NBTTagCompound();
                payload.func_74768_a("action", 1);
                payload.func_74768_a("partyID", partyID);
                PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
            }
        } else {
            BetterQuesting.logger.error("Insufficient permissions to kick " + username + " from party " + partyID);
        }
    }

    private static int checkPermission(UUID playerID, IParty party) {
        EnumPartyStatus status;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            EntityPlayerMP player = null;
            for (Object o : server.func_71203_ab().field_72404_b) {
                if (!((EntityPlayerMP)o).func_146103_bH().getId().equals(playerID)) continue;
                player = (EntityPlayerMP)o;
            }
            if (player != null && server.func_71203_ab().func_152596_g(player.func_146103_bH())) {
                return 4;
            }
        }
        if ((status = party.getStatus(playerID)) == null) {
            return 0;
        }
        switch (status) {
            case MEMBER: {
                return 1;
            }
            case ADMIN: {
                return 2;
            }
            case OWNER: {
                return 3;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        int action = !message.func_150297_b("action", 99) ? -1 : message.func_74762_e("action");
        int partyID = !message.func_150297_b("partyID", 99) ? -1 : message.func_74762_e("partyID");
        switch (action) {
            case 1: {
                PartyManager.INSTANCE.removeID(partyID);
                PartyInvitations.INSTANCE.purgeInvites(partyID);
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.PARTY));
                break;
            }
            case 5: {
                IParty party = (IParty)PartyManager.INSTANCE.getValue(partyID);
                if (party == null) break;
                party.kickUser(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.PARTY));
            }
        }
    }
}

