/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.auracascade.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.mods.auracascade.AuraCascadeHelper;
import modtweaker2.mods.auracascade.aura.IAuraStack;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import pixlepix.auracascade.data.recipe.PylonRecipe;
import pixlepix.auracascade.data.recipe.PylonRecipeComponent;
import pixlepix.auracascade.data.recipe.PylonRecipeRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.auraCascade.Pylon")
public class Pylon {
    protected static final String name = "Aura Cascade Pylon";

    @ZenMethod
    public static void addRecipe(IItemStack ouput, IAuraStack stack, IItemStack input) {
        Pylon.addRecipe(ouput, stack, input, stack, input, stack, input, stack, input);
    }

    @ZenMethod
    public static void addRecipe(IItemStack ouput, IAuraStack aura1, IItemStack input1, IAuraStack aura2, IItemStack input2, IAuraStack aura3, IItemStack input3, IAuraStack aura4, IItemStack input4) {
        LinkedList<PylonRecipe> recipes = new LinkedList<PylonRecipe>();
        recipes.add(new PylonRecipe(InputHelper.toStack(ouput), new PylonRecipeComponent(AuraCascadeHelper.toAura(aura1), InputHelper.toStack(input1)), new PylonRecipeComponent(AuraCascadeHelper.toAura(aura2), InputHelper.toStack(input2)), new PylonRecipeComponent(AuraCascadeHelper.toAura(aura3), InputHelper.toStack(input3)), new PylonRecipeComponent(AuraCascadeHelper.toAura(aura1), InputHelper.toStack(input4))));
        MineTweakerAPI.apply((IUndoableAction)new Add(recipes));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<PylonRecipe> recipes = new LinkedList<PylonRecipe>();
        for (PylonRecipe r : PylonRecipeRegistry.recipes) {
            if (!output.matches(InputHelper.toIItemStack(r.result))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<PylonRecipe> {
        public Remove(List<PylonRecipe> recipes) {
            super(Pylon.name, PylonRecipeRegistry.recipes, recipes);
        }

        @Override
        protected String getRecipeInfo(PylonRecipe recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }

    private static class Add
    extends BaseListAddition<PylonRecipe> {
        public Add(List<PylonRecipe> recipes) {
            super(Pylon.name, PylonRecipeRegistry.recipes, recipes);
        }

        @Override
        protected String getRecipeInfo(PylonRecipe recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }
}

