/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public interface IReactorPart {
    public static int getComparatorOutput(IBlockAccess world, int x, int y, int z) {
        IReactorPart part;
        TileReactorCore core;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IReactorPart && (core = (part = (IReactorPart)tile).getMaster()) != null) {
            return core.getComparatorOutput(part.getComparatorMode());
        }
        return 0;
    }

    public MultiblockHelper.TileLocation getMasterLocation();

    public TileReactorCore getMaster();

    public void setUp(MultiblockHelper.TileLocation var1);

    public void shutDown();

    public boolean isActive();

    public ForgeDirection getFacing();

    public ComparatorMode getComparatorMode();

    public void changeComparatorMode();

    public static enum ComparatorMode {
        TEMPERATURE,
        TEMPERATURE_INVERTED,
        FIELD_CHARGE,
        FIELD_CHARGE_INVERTED,
        ENERGY_SATURATION,
        ENERGY_SATURATION_INVERTED,
        CONVERTED_FUEL,
        CONVERTED_FUEL_INVERTED;

        private static final ComparatorMode[] values;

        public static ComparatorMode getMode(int ordinal) {
            return ordinal >= 0 && ordinal < values.length ? values[ordinal] : TEMPERATURE;
        }

        public ComparatorMode next() {
            return values[(this.ordinal() + 1) % values.length];
        }

        public String toLocalizedString() {
            return StatCollector.func_74838_a((String)("msg.de.reactorRSMode." + this.ordinal() + ".txt"));
        }

        static {
            values = ComparatorMode.values();
        }
    }
}

