/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.face;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IItemable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IRotatable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IScalable;
import com.bymarcin.openglasses.utils.RenderUtils;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemIcon
extends Widget
implements IItemable,
IPositionable,
IScalable,
IRotatable {
    ItemStack itemStack;
    float x;
    float y;
    float scale = 1.0f;
    float rotation;

    @Override
    public void writeData(ByteBuf buff) {
        ByteBufUtils.writeItemStack((ByteBuf)buff, (ItemStack)this.itemStack);
        buff.writeFloat(this.x);
        buff.writeFloat(this.y);
        buff.writeFloat(this.scale);
        buff.writeFloat(this.rotation);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buff);
        this.x = buff.readFloat();
        this.y = buff.readFloat();
        this.scale = buff.readFloat();
        this.rotation = buff.readFloat();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.ITEMICON;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableIcon();
    }

    @Override
    public double getPosX() {
        return this.x;
    }

    @Override
    public double getPosY() {
        return this.y;
    }

    @Override
    public void setPos(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    @Override
    public void setScale(double scale) {
        this.scale = (float)scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public boolean setItem(ItemStack newItem) {
        if (newItem == null || newItem.func_77973_b() == null) {
            return false;
        }
        this.itemStack = newItem;
        return true;
    }

    @Override
    public ItemStack getItem() {
        return this.itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    class RenderableIcon
    implements IRenderableWidget {
        RenderableIcon() {
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            try {
                RenderUtils.renderItemStackOnGUI(ItemIcon.this.itemStack, ItemIcon.this.x, ItemIcon.this.y, ItemIcon.this.scale, ItemIcon.this.rotation);
            }
            catch (RuntimeException e) {
                ItemIcon.this.itemStack = null;
            }
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.GameOverlayLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return ItemIcon.this.isVisible();
        }
    }
}

