/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.function.Predicate;

public enum Mods {
    AdventureBackpack2("adventurebackpack"),
    Ae2("appliedenergistics2"),
    AvaritiaAddons("avaritiaddons"),
    Backhand("backhand"),
    Backpack("Backpack"),
    BetterStorage("betterstorage", Mods.versionMatches("(,0.14)")),
    BetterStorageFixed("betterstorage", Mods.versionMatches("[0.14,)")),
    Bibliocraft("BiblioCraft"),
    Botania("Botania"),
    Buildcraft("BuildCraft|Core"),
    CodeChickenCore("CodeChickenCore"),
    CookingForBlockheads("cookingforblockheads"),
    DraconicEvolution("DraconicEvolution"),
    EnderStorage("EnderStorage"),
    Energycontrol("energycontrol"),
    Etfuturum("etfuturum"),
    ExtraUtilities("ExtraUtilities"),
    Forestry("Forestry"),
    GT5u("gregtech", mod -> !Loader.isModLoaded((String)"gregapi")),
    GT6("gregtech", mod -> Loader.isModLoaded((String)"gregapi")),
    GalacticraftCore("galacticraftcore"),
    HBM("hbm"),
    IC2("IC2", mod -> !mod.getName().endsWith("Classic")),
    IC2Classic("IC2", mod -> mod.getName().endsWith("Classic")),
    ImmersiveEngineering("ImmersiveEngineering"),
    IronChest("IronChest"),
    Mekanism("Mekanism"),
    Nutrition("nutrition"),
    ProjectE("ProjectE"),
    ProjectRed("ProjRed|Expansion"),
    ServerUtilities("serverutilities"),
    StorageDrawers("StorageDrawers"),
    Tconstruct("TConstruct"),
    Terrafirmacraft("terrafirmacraft"),
    Thebetweenlands("thebetweenlands"),
    ActuallyAdditions("ActuallyAdditions"),
    Controlling("controlling");

    private final String modid;
    private final Predicate<ModContainer> modPredicate;
    private Boolean loaded;

    private Mods(String modid) {
        this(modid, mod -> true);
    }

    private Mods(String modid, Predicate<ModContainer> predicate) {
        this.modid = modid;
        this.modPredicate = predicate;
    }

    public boolean isLoaded() {
        if (this.loaded != null) {
            return this.loaded;
        }
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(this.modid);
        if (mod == null) {
            this.loaded = false;
            return this.loaded;
        }
        this.loaded = Loader.isModLoaded((String)this.modid) && this.modPredicate.test(mod);
        return this.loaded;
    }

    public static Predicate<ModContainer> versionMatches(String range) {
        VersionRange versionRange = VersionParser.parseRange((String)range);
        return mod -> {
            ArtifactVersion modVersion = mod.getProcessedVersion();
            return versionRange.containsVersion(modVersion);
        };
    }
}

