/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.common.network.CDropOff;
import com.cleanroommc.bogosorter.common.network.CHotbarSwap;
import com.cleanroommc.bogosorter.common.network.CRefill;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.CSlotSync;
import com.cleanroommc.bogosorter.common.network.CSort;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.cleanroommc.bogosorter.common.network.SDropOffMessage;
import com.cleanroommc.bogosorter.common.network.SDropOffThrottled;
import com.cleanroommc.bogosorter.common.network.SRefillSound;
import com.cleanroommc.bogosorter.common.network.SReloadConfig;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class NetworkHandler {
    public static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("bogosorter");
    private static int packetId = 0;
    static final IMessageHandler<IPacket, IPacket> S2CHandler = (message, ctx) -> {
        NetHandlerPlayClient handler = ctx.getClientHandler();
        return message.executeClient(handler);
    };
    static final IMessageHandler<IPacket, IPacket> C2SHandler = (message, ctx) -> {
        NetHandlerPlayServer handler = ctx.getServerHandler();
        return message.executeServer(handler);
    };

    public static void init() {
        NetworkHandler.registerC2S(CSlotSync.class);
        NetworkHandler.registerC2S(CShortcut.class);
        NetworkHandler.registerC2S(CSort.class);
        NetworkHandler.registerC2S(CHotbarSwap.class);
        NetworkHandler.registerS2C(SReloadConfig.class);
        NetworkHandler.registerS2C(SRefillSound.class);
        NetworkHandler.registerC2S(CDropOff.class);
        NetworkHandler.registerS2C(SDropOffMessage.class);
        NetworkHandler.registerS2C(SDropOffThrottled.class);
        NetworkHandler.registerC2S(CRefill.class);
    }

    private static void registerC2S(Class<? extends IPacket> clazz) {
        network.registerMessage(C2SHandler, clazz, packetId++, Side.SERVER);
    }

    private static void registerS2C(Class<? extends IPacket> clazz) {
        network.registerMessage(S2CHandler, clazz, packetId++, Side.CLIENT);
    }

    public static void sendToServer(IPacket packet) {
        network.sendToServer((IMessage)packet);
    }

    public static void sendToWorld(IPacket packet, World world) {
        network.sendToDimension((IMessage)packet, world.field_73011_w.field_76574_g);
    }

    public static void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        network.sendTo((IMessage)packet, player);
    }
}

